/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.netty.msg.SimpleModbusMessageReply;
import net.solarnetwork.io.modbus.tcp.SimpleTransactionIdSupplier;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessageDecoder;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpModbusServer {
    public static final long DEFAULT_PENDING_MESSAGE_TTL = TimeUnit.MINUTES.toMillis(2L);
    public static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    private static final Logger log = LoggerFactory.getLogger(NettyTcpModbusServer.class);
    private final ConcurrentMap<Integer, TcpModbusMessage> pendingMessages;
    private final IntSupplier transactionIdSupplier;
    private final String bindAddress;
    private final int port;
    private ScheduledFuture<?> cleanupTask;
    private BiConsumer<ModbusMessage, Consumer<ModbusMessage>> messageHandler;
    private long pendingMessageTtl = DEFAULT_PENDING_MESSAGE_TTL;
    private boolean wireLogging;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NettyTcpModbusServer(int port) {
        this(port, new ConcurrentHashMap<Integer, TcpModbusMessage>(8, 0.9f, 2), SimpleTransactionIdSupplier.INSTANCE);
    }

    public NettyTcpModbusServer(String bindAddress, int port) {
        this(bindAddress, port, new ConcurrentHashMap<Integer, TcpModbusMessage>(8, 0.9f, 2), SimpleTransactionIdSupplier.INSTANCE);
    }

    public NettyTcpModbusServer(int port, ConcurrentMap<Integer, TcpModbusMessage> pendingMessages, IntSupplier transactionIdSupplier) {
        this(DEFAULT_BIND_ADDRESS, port, pendingMessages, transactionIdSupplier);
    }

    public NettyTcpModbusServer(String bindAddress, int port, ConcurrentMap<Integer, TcpModbusMessage> pendingMessages, IntSupplier transactionIdSupplier) {
        if (bindAddress == null) {
            throw new IllegalArgumentException("The bindAddress argument must not be null.");
        }
        this.bindAddress = bindAddress;
        this.port = port;
        if (pendingMessages == null) {
            throw new IllegalArgumentException("The pendingMessages argument must not be null.");
        }
        this.pendingMessages = pendingMessages;
        if (transactionIdSupplier == null) {
            throw new IllegalArgumentException("The transactionIdSupplier argument must not be null.");
        }
        this.transactionIdSupplier = transactionIdSupplier;
    }

    public synchronized void start() throws IOException {
        if (this.channel != null) {
            return;
        }
        try {
            long period;
            final NioEventLoopGroup bGroup = new NioEventLoopGroup();
            this.bossGroup = bGroup;
            final NioEventLoopGroup wGroup = new NioEventLoopGroup();
            this.workerGroup = wGroup;
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bGroup, (EventLoopGroup)wGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChildHandlerInitializer()).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            Channel channel = bootstrap.bind(this.bindAddress, this.port).sync().channel();
            channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    wGroup.shutdownGracefully();
                    bGroup.shutdownGracefully();
                }
            });
            this.channel = channel;
            if (this.cleanupTask == null && (period = this.getPendingMessageTtl() * 2L) > 0L) {
                this.cleanupTask = bGroup.scheduleWithFixedDelay((Runnable)new PendingMessageExpiredCleaner(), period, period, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            String msg = String.format("Error starting Modbus server on port %d", this.port);
            if (e instanceof IOException) {
                log.warn("{}: {}", (Object)msg, (Object)e.getMessage());
                throw (IOException)e;
            }
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public synchronized void stop() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel(true);
            this.cleanupTask = null;
        }
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
            this.channel = null;
        }
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public BiConsumer<ModbusMessage, Consumer<ModbusMessage>> getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(BiConsumer<ModbusMessage, Consumer<ModbusMessage>> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public boolean isWireLogging() {
        return this.wireLogging;
    }

    public void setWireLogging(boolean wireLogging) {
        this.wireLogging = wireLogging;
    }

    public long getPendingMessageTtl() {
        return this.pendingMessageTtl;
    }

    public void setPendingMessageTtl(long pendingMessageTtl) {
        this.pendingMessageTtl = pendingMessageTtl;
    }

    private final class PendingMessageExpiredCleaner
    implements Runnable {
        private PendingMessageExpiredCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug("Looking for expired pending Modbus messages");
            int expiredCount = 0;
            long now = System.currentTimeMillis();
            try {
                Iterator itr = NettyTcpModbusServer.this.pendingMessages.values().iterator();
                while (itr.hasNext()) {
                    TcpModbusMessage pending = (TcpModbusMessage)itr.next();
                    if (pending.getTimestamp() + NettyTcpModbusServer.this.pendingMessageTtl >= now) continue;
                    log.warn("Dropping pending Modbus request message that has not had a response provided within {}ms: {}", (Object)NettyTcpModbusServer.this.pendingMessageTtl, (Object)pending);
                    itr.remove();
                    ++expiredCount;
                }
            }
            catch (Exception e) {
                log.warn("Exception cleaning expired pending Modbus requests: {}", (Object)e.toString(), (Object)e);
            }
            finally {
                if (expiredCount < 1) {
                    log.debug("Finished cleaning expired pending Modbus requests; none expired.");
                } else {
                    log.info("Finished cleaning expired pending Modbus requests; {} expired.", (Object)expiredCount);
                }
            }
        }
    }

    private final class ChildHandler
    extends SimpleChannelInboundHandler<ModbusMessage> {
        private ChildHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            log.info("Client connected: {}", (Object)ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            log.info("Client disconnected: {}", (Object)ctx.channel());
        }

        protected void channelRead0(ChannelHandlerContext ctx, ModbusMessage msg) throws Exception {
            log.debug("Request: {}", (Object)msg);
            BiConsumer<ModbusMessage, Consumer<ModbusMessage>> h = NettyTcpModbusServer.this.getMessageHandler();
            if (h == null) {
                return;
            }
            h.accept(msg, r -> ctx.channel().writeAndFlush((Object)new SimpleModbusMessageReply(msg, r)));
        }
    }

    private final class ChildHandlerInitializer
    extends ChannelInitializer<SocketChannel> {
        private ChildHandlerInitializer() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            if (NettyTcpModbusServer.this.wireLogging) {
                pipeline.addLast(new ChannelHandler[]{new LoggingHandler("net.solarnetwork.io.modbus.server." + NettyTcpModbusServer.this.port)});
            }
            pipeline.addLast(new ChannelHandler[]{new TcpModbusMessageEncoder(NettyTcpModbusServer.this.pendingMessages, NettyTcpModbusServer.this.transactionIdSupplier), new TcpModbusMessageDecoder(false, NettyTcpModbusServer.this.pendingMessages), new ChildHandler()});
        }
    }
}

