/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp.netty;

import io.netty.buffer.ByteBuf;
import net.solarnetwork.io.modbus.ModbusByteUtils;
import net.solarnetwork.io.modbus.ModbusError;
import net.solarnetwork.io.modbus.ModbusFunction;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.ModbusValidationException;
import net.solarnetwork.io.modbus.netty.msg.ModbusPayloadEncoder;

public class TcpModbusMessage
implements net.solarnetwork.io.modbus.tcp.TcpModbusMessage,
ModbusPayloadEncoder {
    public static final int TCP_PROTOCOL_ID = 0;
    private final long timestamp;
    private final int transactionId;
    private final ModbusMessage body;

    public TcpModbusMessage(int transactionId, ModbusMessage body) {
        this(System.currentTimeMillis(), transactionId, body);
    }

    public TcpModbusMessage(long timestamp, int transactionId, ModbusMessage body) {
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        if (body == null) {
            throw new IllegalArgumentException("The body argument must not be null.");
        }
        if (!(body instanceof ModbusPayloadEncoder)) {
            throw new IllegalArgumentException("The body argument must implement ModbusPayloadEncoder.");
        }
        this.body = body;
    }

    @Override
    public TcpModbusMessage validate() throws ModbusValidationException {
        this.body.validate();
        return this;
    }

    public boolean isSameAs(ModbusMessage obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TcpModbusMessage)) {
            return false;
        }
        TcpModbusMessage other = (TcpModbusMessage)obj;
        if (this.transactionId != other.transactionId) {
            return false;
        }
        return this.body.isSameAs(other.body);
    }

    public <T extends ModbusMessage> T unwrap(Class<T> msgType) {
        if (net.solarnetwork.io.modbus.tcp.TcpModbusMessage.class.isAssignableFrom(msgType)) {
            return (T)this;
        }
        return (T)this.body.unwrap(msgType);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TcpModbusMessage{ts=");
        builder.append(this.timestamp);
        builder.append(", txId=");
        builder.append(this.transactionId);
        builder.append(", body=");
        builder.append(this.body);
        builder.append("}");
        return builder.toString();
    }

    public ModbusMessage getBody() {
        return this.body;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getTransactionId() {
        return this.transactionId;
    }

    public int getUnitId() {
        return this.body.getUnitId();
    }

    public ModbusFunction getFunction() {
        return this.body.getFunction();
    }

    public ModbusError getError() {
        return this.body.getError();
    }

    public void encodeModbusPayload(ByteBuf out) {
        byte[] header = new byte[7];
        ModbusByteUtils.encode16((byte[])header, (int)0, (int)this.transactionId);
        ModbusByteUtils.encode16((byte[])header, (int)4, (int)(1 + ((ModbusPayloadEncoder)this.body).payloadLength()));
        header[6] = (byte)this.body.getUnitId();
        out.writeBytes(header);
        ((ModbusPayloadEncoder)this.body).encodeModbusPayload(out);
    }

    public int payloadLength() {
        return 7 + ((ModbusPayloadEncoder)this.body).payloadLength();
    }
}

