/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.bot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.hurstfrost.game.millebornes.bot.Group;
import net.hurstfrost.game.millebornes.bot.MultiBotConfigReader;
import net.hurstfrost.game.millebornes.bot.Opponent;
import net.hurstfrost.game.millebornes.bot.TestBot;
import net.hurstfrost.game.millebornes.bot.User;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MultiBot {
    private static final Logger log = Logger.getLogger(MultiBot.class);

    public static void main(String[] args) throws SAXException, IOException, InterruptedException {
        MultiBotConfigReader documentHandler = new MultiBotConfigReader();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(documentHandler);
        String resourceName = null;
        String baseUrl = null;
        for (int i = 0; i < args.length; ++i) {
            if (resourceName == null) {
                resourceName = args[i];
                continue;
            }
            if (baseUrl != null) continue;
            baseUrl = args[i];
        }
        if (resourceName == null) {
            System.err.println("Usage:");
            System.err.println("  java " + MultiBot.class.getName() + " <config> [<base URL>]");
            System.err.println("    <config>   - name of resource containing config XML");
            System.err.println("    <base URL> - location of game server (default http://localhost:8080/jsmb-dev/)");
            return;
        }
        InputStream resourceAsStream = MultiBot.class.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            System.err.println("Can't find resource '" + resourceName + "'");
            return;
        }
        reader.parse(new InputSource(resourceAsStream));
        log.info((Object)("Read configuration from " + resourceName));
        if (baseUrl != null) {
            log.info((Object)("Playing against game server at " + baseUrl));
        }
        ArrayList<TestBot> bots = new ArrayList<TestBot>();
        for (Group group : documentHandler.getGroups().values()) {
            for (User user : group.getUsers()) {
                for (int i = 0; i < user.getNumber(); ++i) {
                    if (!user.getOpponents().isEmpty()) {
                        for (Opponent opponent : user.getOpponents()) {
                            for (int j = 0; j < opponent.getNumber(); ++j) {
                                TestBot bot = MultiBot.createNewBot(user, i, opponent, (i + j) % user.getNumber());
                                if (baseUrl != null) {
                                    bot.setBasePath(baseUrl);
                                }
                                bots.add(bot);
                            }
                        }
                        continue;
                    }
                    TestBot bot = MultiBot.createNewBot(user, i, null, 0);
                    if (baseUrl != null) {
                        bot.setBasePath(baseUrl);
                    }
                    bots.add(bot);
                }
            }
        }
        log.info((Object)("Starting the " + bots.size() + " bots..."));
        for (TestBot bot : bots) {
            bot.start();
        }
        log.info((Object)"Logging in and looking up game...");
        for (TestBot bot : bots) {
            bot.login();
        }
        for (TestBot bot : bots) {
            bot.waitState(TestBot.State.LOGGED_IN, TestBot.State.ERROR);
            if (bot.isState(TestBot.State.ERROR)) {
                log.info((Object)"Bot failed to log in");
                continue;
            }
            bot.prepare();
            bot.waitState(TestBot.State.READY, TestBot.State.ERROR);
        }
        log.info((Object)"All logged in, starting to play");
        for (TestBot bot : bots) {
            bot.play();
        }
        for (TestBot bot : bots) {
            bot.join();
        }
    }

    private static TestBot createNewBot(User user, int i, Opponent opponent, int j) {
        log.debug((Object)String.format("email=%s password=%s", user.getEmail(i), user.getPassword(i)));
        log.debug((Object)String.format("opponent=%s", opponent == null ? "quick" : opponent.getNick(j)));
        TestBot testBot = new TestBot(user.getEmail(i), user.getPassword(i), opponent == null ? "quick" : opponent.getNick(j), user.getWaitMillis());
        testBot.setCreateGame(user.isCreateGame());
        testBot.setDelay(user.getDelay(i));
        if (user.getLeaveWait() > 0) {
            testBot.setLeave(true);
            testBot.setLeaveWait(user.getLeaveWait());
        }
        return testBot;
    }
}

