/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.bot;

import java.util.HashMap;
import java.util.Map;
import net.hurstfrost.game.millebornes.bot.Group;
import net.hurstfrost.game.millebornes.bot.Opponent;
import net.hurstfrost.game.millebornes.bot.User;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBotConfigReader
extends DefaultHandler {
    private Map<String, Group> m_groups = new HashMap<String, Group>();
    private Group m_currentGroup;
    private User m_currentUser;

    public Map<String, Group> getGroups() {
        return this.m_groups;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (name.equals("group")) {
            String groupName = attributes.getValue("name");
            this.m_currentGroup = new Group();
            this.m_groups.put(groupName, this.m_currentGroup);
        } else if (name.equals("user")) {
            String email = attributes.getValue("email");
            String password = attributes.getValue("password");
            String number = attributes.getValue("number");
            String wait = attributes.getValue("wait");
            String create = attributes.getValue("create");
            String delay = attributes.getValue("delay");
            String leaveWait = attributes.getValue("leave-wait");
            this.m_currentUser = new User(email, password);
            if (number != null) {
                this.m_currentUser.setNumber(Integer.parseInt(number));
            }
            if (wait != null) {
                this.m_currentUser.setWait(Integer.parseInt(wait));
            }
            if (create != null) {
                this.m_currentUser.setCreateGame(Boolean.parseBoolean(create));
            }
            if (delay != null) {
                this.m_currentUser.setDelay(delay);
            }
            if (leaveWait != null) {
                this.m_currentUser.setLeaveWait(Integer.parseInt(leaveWait));
            }
            this.m_currentGroup.add(this.m_currentUser);
        } else if (name.equals("opponent")) {
            Opponent opponent = new Opponent(attributes.getValue("nick"));
            this.m_currentUser.addOpponent(opponent);
            String number = attributes.getValue("number");
            if (number != null) {
                opponent.setNumber(Integer.parseInt(number));
            }
        }
    }
}

