/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.bot;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.TableRow;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.hurstfrost.game.millebornes.bot.InvalidGameException;
import net.hurstfrost.game.millebornes.bot.ServerErrorException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class TestBot
extends Thread {
    private static final Logger log = Logger.getLogger(TestBot.class);
    public static final String DEFAULT_BASE_PATH = "http://localhost:8080/jsmb-dev/";
    private String m_clientId;
    private List<String> m_hand = new ArrayList<String>();
    private Map<String, String> m_revealed = new HashMap<String, String>();
    private boolean m_proceedNext;
    private final String m_login;
    private final String m_password;
    private int m_gameId;
    private final String m_opponentNick;
    private int m_waitMillis = 1000;
    private int m_delay = 0;
    private final WebConversation m_webConversation;
    private boolean m_createGame;
    private boolean m_leave;
    private int m_leaveWait;
    private String m_basePath = "http://localhost:8080/jsmb-dev/";
    private State m_state;
    private boolean m_register = true;

    public static void main(String[] args) throws Exception {
        TestBot testBot = new TestBot(args[0], args[1], Integer.parseInt(args[2]));
        if (testBot.doLogin(false)) {
            testBot.doGame();
        }
    }

    public TestBot(String login, String password, int gameId) {
        super(login + " in game " + gameId);
        this.setDaemon(true);
        this.m_login = login;
        this.m_password = password;
        this.m_gameId = gameId;
        this.m_opponentNick = null;
        this.m_webConversation = new WebConversation();
    }

    public TestBot(String email, String password, String nick, int waitMillis) {
        super(email + " against " + nick);
        this.setDaemon(true);
        this.m_login = email;
        this.m_password = password;
        this.m_opponentNick = nick;
        this.m_waitMillis = waitMillis;
        this.m_webConversation = new WebConversation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            this.waitState(State.LOGIN);
            if (this.m_login != null) {
                if (!this.doLogin(this.m_register)) return;
                this.setState(State.LOGGED_IN);
                this.waitState(State.PREPARE);
                this.prepareForPlay();
                this.setState(State.READY);
            } else {
                this.setState(State.LOGGED_IN);
                this.waitState(State.PREPARE);
                this.setState(State.READY);
            }
            this.waitState(State.GO);
            this.setState(State.RUNNING);
            while (this.doGame()) {
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)e);
            return;
        }
        finally {
            this.setState(State.ERROR);
            log.info((Object)("Game thread for " + this.m_login + " terminated"));
        }
    }

    public void login() {
        this.setState(State.LOGIN);
    }

    public void prepare() {
        this.setState(State.PREPARE);
    }

    public void play() {
        this.setState(State.GO);
    }

    private synchronized void setState(State state) {
        this.m_state = state;
        this.notify();
    }

    public synchronized void waitState(State ... state) throws InterruptedException {
        while (true) {
            for (int i = 0; i < state.length; ++i) {
                if (!state[i].equals((Object)this.m_state)) continue;
                return;
            }
            this.wait();
        }
    }

    public boolean isState(State ... state) {
        for (int i = 0; i < state.length; ++i) {
            if (!state[i].equals((Object)this.m_state)) continue;
            return true;
        }
        return false;
    }

    private boolean runGameLoop() throws IOException, JSONException, InterruptedException, SAXException {
        Thread.sleep(this.m_delay);
        while (this.runTurn()) {
            if (this.m_leave) {
                this.doLeaveGame();
                this.m_clientId = null;
                return true;
            }
            Thread.sleep(this.m_waitMillis);
        }
        return false;
    }

    public void setDelay(int delay) {
        this.m_delay = delay;
    }

    public String getLogin() {
        return this.m_login;
    }

    private boolean runTurn() throws IOException, JSONException, SAXException {
        GetMethodWebRequest getRunTurn = new GetMethodWebRequest(this.getGameUrl("run_turn.htm?cid=" + this.m_clientId));
        WebResponse runTurnJson = this.getResponse(getRunTurn);
        JSONObject runTurn = new JSONObject(runTurnJson.getText());
        return this.processRunTurnResponse(runTurn);
    }

    private boolean processRunTurnResponse(JSONObject runTurn) throws JSONException, IOException, SAXException {
        log.debug((Object)(this.m_clientId + ":" + runTurn));
        this.updateCardState(runTurn);
        if (runTurn.opt("invalidGame") != null) {
            throw new InvalidGameException();
        }
        if (this.isNewHand(runTurn)) {
            this.doLayout();
            return true;
        }
        if (this.isProceedNext(runTurn)) {
            this.m_proceedNext = true;
        }
        if (this.isHandComplete(runTurn)) {
            if (!this.m_proceedNext) {
                return this.doNextHand();
            }
            return true;
        }
        Boolean enableUi = (Boolean)runTurn.opt("enableUI");
        if (enableUi == null || !enableUi.booleanValue()) {
            return true;
        }
        if (this.isAskExtend(runTurn)) {
            return this.doExtend(false);
        }
        JSONObject hint = (JSONObject)runTurn.get("hint");
        if (hint != null) {
            log.debug((Object)hint);
            Object action = hint.get("action");
            if (action.equals("PICKUP")) {
                return this.doPickup();
            }
            if (action.equals("PLAY")) {
                String cardId = this.findInHand((String)hint.get("card"));
                return this.doPlay(cardId);
            }
            if (action.equals("DISCARD")) {
                String cardId = this.findInHand((String)hint.get("card"));
                return this.doDiscard(cardId);
            }
        }
        return true;
    }

    private boolean doGame() throws IOException, JSONException, InterruptedException, SAXException {
        GetMethodWebRequest getPlay = this.m_login != null ? new GetMethodWebRequest(this.getGameUrl("play.htm?id=" + this.m_gameId)) : new GetMethodWebRequest(this.getGameUrl("quick_game.htm"));
        WebResponse gamePage = this.getResponse(getPlay);
        this.m_clientId = TestBot.getClientId(gamePage);
        log.info((Object)("Got layout for client " + this.m_clientId));
        this.doLayout();
        boolean cont = this.runGameLoop();
        if (cont) {
            Thread.sleep(this.m_leaveWait);
        }
        return cont;
    }

    private boolean doNextHand() throws IOException, JSONException, SAXException {
        log.info((Object)"Next hand");
        GetMethodWebRequest nextHand = new GetMethodWebRequest(this.getGameUrl("do_control.htm?cid=" + this.m_clientId + "&control=next_hand"));
        WebResponse nextHandJson = this.getResponse(nextHand);
        if (nextHandJson.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        return this.processRunTurnResponse(new JSONObject(nextHandJson.getText()));
    }

    private boolean doExtend(boolean extend) throws IOException, JSONException, SAXException {
        log.info((Object)("Extend " + extend));
        GetMethodWebRequest getExtend = new GetMethodWebRequest(this.getGameUrl("do_extend.htm?cid=" + this.m_clientId + "&extend=" + extend));
        WebResponse extendJson = this.getResponse(getExtend);
        if (extendJson.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        return this.processRunTurnResponse(new JSONObject(extendJson.getText()));
    }

    private boolean doDiscard(String cardId) throws IOException, JSONException, SAXException {
        log.debug((Object)("Discard " + this.m_revealed.get(cardId)));
        GetMethodWebRequest getDiscard = new GetMethodWebRequest(this.getGameUrl("do_discard.htm?cid=" + this.m_clientId + "&card=id_" + cardId));
        WebResponse discardJson = this.getResponse(getDiscard);
        if (discardJson.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        return this.processRunTurnResponse(new JSONObject(discardJson.getText()));
    }

    private boolean doPlay(String cardId) throws IOException, JSONException, SAXException {
        log.debug((Object)("Play " + this.m_revealed.get(cardId)));
        GetMethodWebRequest getPlay = new GetMethodWebRequest(this.getGameUrl("do_play.htm?cid=" + this.m_clientId + "&card=id_" + cardId));
        WebResponse playPage = this.m_webConversation.getResource((WebRequest)getPlay);
        if (playPage.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        return this.processRunTurnResponse(new JSONObject(playPage.getText()));
    }

    private boolean doPickup() throws IOException, JSONException, SAXException {
        log.debug((Object)"Pickup");
        GetMethodWebRequest getPickup = new GetMethodWebRequest(this.getGameUrl("do_pickup.htm?cid=" + this.m_clientId));
        WebResponse pickupPage = this.getResponse(getPickup);
        if (pickupPage.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        return this.processRunTurnResponse(new JSONObject(pickupPage.getText()));
    }

    private void doLayout() throws IOException, JSONException, SAXException {
        this.m_proceedNext = false;
        this.m_hand = new ArrayList<String>();
        this.m_revealed = new HashMap<String, String>();
        GetMethodWebRequest getLayout = new GetMethodWebRequest(this.getGameUrl("do_layout.htm?cid=" + this.m_clientId));
        WebResponse layoutJson = this.getResponse(getLayout);
        if (layoutJson.getResponseCode() != 200) {
            throw new ServerErrorException();
        }
        JSONObject layout = new JSONObject(layoutJson.getText());
        JSONObject zones = (JSONObject)layout.get("zone");
        JSONArray hand = (JSONArray)zones.get("hand");
        for (int i = 0; i < hand.length(); ++i) {
            this.m_hand.add((String)hand.get(i));
        }
        JSONObject reveal = (JSONObject)layout.get("reveal");
        Iterator keys = reveal.keys();
        while (keys.hasNext()) {
            String k = (String)keys.next();
            this.m_revealed.put(k, (String)reveal.get(k));
        }
    }

    private boolean doLeaveGame() throws MalformedURLException, IOException, SAXException {
        GetMethodWebRequest getCreateGamePage = new GetMethodWebRequest(this.getGameUrl("leave_game.htm?cid=" + this.m_clientId + "&id=" + this.m_gameId));
        this.getResponse(getCreateGamePage);
        return true;
    }

    boolean doLogin(boolean register) throws IOException, SAXException {
        GetMethodWebRequest getLogin = new GetMethodWebRequest(this.getGameUrl("login.htm"));
        WebResponse loginPage = this.getResponse(getLogin);
        WebForm loginForm = loginPage.getFormWithID("form");
        loginForm.setParameter("email", this.m_login);
        loginForm.setParameter("password", this.m_password);
        WebResponse response = loginForm.submit();
        if (!response.getURL().getPath().endsWith("home.htm")) {
            if (register) {
                return this.doRegister();
            }
            return false;
        }
        log.info((Object)("Logged in as " + this.m_login));
        return true;
    }

    private WebResponse getResponse(GetMethodWebRequest request) throws MalformedURLException, IOException, SAXException {
        long start = System.currentTimeMillis();
        log.debug((Object)("Requesting " + request.getURL() + "..."));
        WebResponse response = this.m_webConversation.getResponse((WebRequest)request);
        log.debug((Object)(request.getURL() + " took " + (System.currentTimeMillis() - start) + "ms"));
        return response;
    }

    private boolean doRegister() throws IOException, SAXException {
        GetMethodWebRequest getRegisterPage = new GetMethodWebRequest(this.getGameUrl("register.htm"));
        WebResponse registerPage = this.getResponse(getRegisterPage);
        WebForm registerForm = registerPage.getFormWithID("form");
        registerForm.setParameter("email", this.m_login);
        registerForm.setParameter("password", this.m_password);
        registerForm.setParameter("nickName", this.m_login);
        WebResponse response = registerForm.submit();
        if (!response.getURL().getPath().endsWith("home.htm")) {
            return false;
        }
        log.info((Object)("Registered " + this.m_login));
        return true;
    }

    private boolean doCreateGame() throws IOException, SAXException {
        GetMethodWebRequest getCreateGamePage = new GetMethodWebRequest(this.getGameUrl("new_game.htm"));
        WebResponse createGamePage = this.getResponse(getCreateGamePage);
        WebForm createGameForm = createGamePage.getFormWithID("form");
        createGameForm.setParameter("opponent", this.m_opponentNick);
        WebResponse response = createGameForm.submit();
        if (!response.getURL().getPath().endsWith("home.htm")) {
            return false;
        }
        log.info((Object)("Game created between " + this.m_login + " and " + this.m_opponentNick));
        return true;
    }

    private int getGameId(String opponentNick) throws IOException, SAXException {
        GetMethodWebRequest getGamesPage = new GetMethodWebRequest(this.getGameUrl("home.htm"));
        WebResponse homePage = this.getResponse(getGamesPage);
        WebTable gamesTable = homePage.getTables()[0];
        TableRow[] rows = gamesTable.getRows();
        for (int i = 1; i < rows.length; ++i) {
            String url;
            int indexOfId;
            TableCell gameCell;
            WebLink[] links;
            if (!gamesTable.getCellAsText(i, 0).equals(opponentNick) || (links = (gameCell = gamesTable.getTableCell(i, 0)).getLinks()).length <= 0 || (indexOfId = (url = links[0].getURLString()).indexOf("?id=")) < 0) continue;
            int gameId = Integer.parseInt(url.substring(indexOfId + 4));
            log.debug((Object)("Got game ID " + gameId + " for " + this.m_login + " against " + this.m_opponentNick));
            return gameId;
        }
        return 0;
    }

    private void updateCardState(JSONObject response) throws JSONException {
        JSONArray events = (JSONArray)response.opt("events");
        if (events == null) {
            log.debug((Object)"No events");
            return;
        }
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = (JSONObject)events.get(i);
            if (!"CARD_MOVED".equals(event.get("type"))) continue;
            String cardId = (String)event.get("card");
            boolean fromHand = "hand".equals(event.get("from_area"));
            boolean toHand = "hand".equals(event.get("to_area"));
            if (event.opt("cardType") != null) {
                String cardType = event.getString("cardType");
                this.m_revealed.put(cardId, cardType);
            }
            if (fromHand && !toHand) {
                if (!this.m_hand.remove(cardId)) continue;
                log.debug((Object)("Card " + cardId + " type:" + this.m_revealed.get(cardId) + " removed from hand"));
                continue;
            }
            if (!toHand || fromHand || !this.m_hand.add(cardId)) continue;
            log.debug((Object)("Card ID:" + cardId + " type:" + this.m_revealed.get(cardId) + " added to hand"));
        }
    }

    private String findInHand(String cardType) {
        for (String hardCardId : this.m_hand) {
            String type = this.m_revealed.get(hardCardId);
            if (type == null) {
                throw new RuntimeException("No card of type " + cardType + " found in hand.");
            }
            if (!type.equals(cardType)) continue;
            return hardCardId;
        }
        throw new RuntimeException("No card of type " + cardType + " found in hand. " + this.m_hand + ":" + this.m_revealed);
    }

    private static String getClientId(WebResponse playPage) throws IOException {
        String pageBody = playPage.getText();
        int i = pageBody.indexOf("CLIENT_ID");
        int j = pageBody.indexOf(39, i + 1);
        return pageBody.substring(j + 1, pageBody.indexOf(39, j + 1));
    }

    private boolean isAskExtend(JSONObject response) throws JSONException {
        JSONArray events = (JSONArray)response.opt("events");
        if (events == null) {
            return false;
        }
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = (JSONObject)events.get(i);
            if (!"ASK_EXTEND".equals(event.get("type"))) continue;
            return true;
        }
        return false;
    }

    private boolean isNewHand(JSONObject response) throws JSONException {
        JSONArray events = (JSONArray)response.opt("events");
        if (events == null) {
            return false;
        }
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = (JSONObject)events.get(i);
            if (!"NEW_HAND".equals(event.get("type"))) continue;
            return true;
        }
        return false;
    }

    private boolean isProceedNext(JSONObject response) throws JSONException {
        JSONArray events = (JSONArray)response.opt("events");
        if (events == null) {
            return false;
        }
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = (JSONObject)events.get(i);
            if (!"PLAYER_CHANGED".equals(event.get("type")) || !event.get("this").equals(Boolean.TRUE) || !event.get("proceedNext").equals(Boolean.TRUE)) continue;
            return true;
        }
        return false;
    }

    private boolean isHandComplete(JSONObject response) throws JSONException {
        JSONArray events = (JSONArray)response.opt("events");
        if (events == null) {
            return false;
        }
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = (JSONObject)events.get(i);
            if ("HAND_COMPLETE".equals(event.get("type"))) {
                return true;
            }
            if (!"GAME_COMPLETE".equals(event.get("type"))) continue;
            return true;
        }
        return false;
    }

    public void prepareForPlay() throws IOException, SAXException {
        if (this.m_gameId == 0) {
            this.m_gameId = this.getGameId(this.m_opponentNick);
            if (this.m_gameId == 0 && this.m_createGame) {
                if (this.doCreateGame()) {
                    this.m_gameId = this.getGameId(this.m_opponentNick);
                } else {
                    throw new RuntimeException("Unable to create game");
                }
            }
            if (this.m_gameId == 0) {
                throw new RuntimeException("Unable to get game ID for " + this.m_opponentNick);
            }
        }
    }

    private String getGameUrl(String path) {
        return this.m_basePath + path;
    }

    public boolean isCreateGame() {
        return this.m_createGame;
    }

    public void setCreateGame(boolean createGame) {
        this.m_createGame = createGame;
    }

    public void setLeave(boolean leave) {
        this.m_leave = leave;
    }

    public void setLeaveWait(int leaveWait) {
        this.m_leaveWait = leaveWait;
    }

    public void setBasePath(String basePath) {
        this.m_basePath = basePath;
    }

    static {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        LOGIN,
        LOGGED_IN,
        PREPARE,
        RUNNING,
        STARTING,
        READY,
        GO,
        ERROR;

    }
}

