/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.k8055;

import net.hurstfrost.k8055.K8055;
import net.hurstfrost.k8055.K8055EventListener;
import net.hurstfrost.k8055.NotConnectedException;

public class K8055Impl
implements K8055 {
    private static final int NOT_CONNECTED = -1;
    private int m_cardAddress = -1;
    private K8055EventListener m_listener;
    private int m_lastAllDigital;

    public synchronized boolean openDevice(int addr) {
        int result = (int)K8055Impl.OpenDevice(addr);
        if (result == addr) {
            this.m_cardAddress = result;
            return true;
        }
        this.m_cardAddress = -1;
        return false;
    }

    public synchronized boolean setDevice(int address) {
        int result = (int)K8055Impl.SetCurrentDevice(address);
        if (result == address) {
            this.m_cardAddress = result;
            return true;
        }
        this.m_cardAddress = -1;
        return false;
    }

    public boolean[] getDevices() {
        int r = (int)K8055Impl.SearchDevices();
        boolean[] result = new boolean[4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (r & 1 << i) != 0;
        }
        return result;
    }

    public synchronized void closeDevice() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        K8055Impl.CloseDevice();
        this.m_cardAddress = -1;
    }

    private boolean isConnected() {
        return this.m_cardAddress != -1;
    }

    public synchronized void setDigitalOutput(int channel) throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        K8055Impl.SetDigitalChannel(channel + 1);
    }

    public synchronized void clearDigitalOutput(int channel) throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        K8055Impl.ClearDigitalChannel(channel + 1);
    }

    public synchronized void clearAllDigital() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        K8055Impl.ClearAllDigital();
    }

    public synchronized int getDigitalInputs() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        long response = K8055Impl.ReadAllDigital();
        if (response < 0L) {
            this.m_cardAddress = -1;
            throw new NotConnectedException();
        }
        return (int)response;
    }

    public boolean getDigitalInput(int channel) throws NotConnectedException {
        return (this.getDigitalInputs() & 1 << channel) != 0;
    }

    public synchronized void setListener(K8055EventListener listener) {
        this.m_listener = listener;
    }

    public synchronized void poll() throws NotConnectedException {
        int allDigital = this.getDigitalInputs();
        if (this.m_listener != null && this.m_lastAllDigital != allDigital) {
            int i = 0;
            int mask = 1;
            while (i < 5) {
                if ((this.m_lastAllDigital & mask) != (allDigital & mask)) {
                    this.m_listener.digitalInputChannelChanged(i, (allDigital & mask) != 0);
                }
                ++i;
                mask <<= 1;
            }
        }
        this.m_lastAllDigital = allDigital;
    }

    private static native long OpenDevice(long var0);

    private static native void CloseDevice();

    private static native void SetDigitalChannel(long var0);

    private static native void ClearDigitalChannel(long var0);

    private static native void ClearAllDigital();

    private static native long ReadAllDigital();

    private static native long SetCurrentDevice(long var0);

    private static native long SearchDevices();

    private static native void Version();

    static {
        try {
            System.loadLibrary("k8055-jni");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("java.library.path=" + System.getProperty("java.library.path"));
            throw e;
        }
    }
}

