/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.applet;

import com.caucho.burlap.client.BurlapProxyFactory;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import net.hurstfrost.santa.control.SantaControlService;
import net.hurstfrost.santa.sound.SantaSoundService;
import net.hurstfrost.santa.swing.SantaMotionPanel;
import net.hurstfrost.santa.swing.SantaSoundPanel;
import net.hurstfrost.santa.swing.SantaSpeechPanel;
import org.apache.log4j.Logger;

public class SantaApplet
extends Applet {
    private static final Logger log = Logger.getLogger(SantaApplet.class);
    private SantaControlService m_santaControlService;
    private SantaSoundService m_santaSoundService;

    public void init() {
        URL codeBase = this.getCodeBase();
        log.debug((Object)("Code base is " + codeBase));
        BurlapProxyFactory factory = new BurlapProxyFactory();
        String location = codeBase.toString() + "santaControl";
        try {
            log.debug((Object)("Connecting to SantaControlService at " + location));
            this.m_santaControlService = (SantaControlService)factory.create(SantaControlService.class, location);
            this.m_santaSoundService = (SantaSoundService)factory.create(SantaSoundService.class, location);
            this.setLayout(new BorderLayout());
            log.debug((Object)"Adding control panel");
            this.add((Component)new SantaSpeechPanel(this.m_santaSoundService), "North");
            log.debug((Object)"Adding sound panel");
            this.add((Component)new SantaSoundPanel(this.m_santaSoundService), "Center");
            log.debug((Object)"Adding motion panel");
            this.add((Component)new SantaMotionPanel(this.m_santaControlService), "South");
        }
        catch (MalformedURLException e) {
            log.error((Object)("Unable to connect to SantaControlService at " + location), (Throwable)e);
        }
    }
}

