/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.hurstfrost.santa.sound.SantaSoundService;
import net.hurstfrost.santa.sound.SoundBiteException;
import net.hurstfrost.santa.swing.SoundBiteTagsDialog;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AddSoundBiteDialog
extends JDialog {
    private static final int MAX_AUDIO_SIZE = 262144;
    private final SantaSoundService m_santaSoundService;
    private JTextField m_biteName;
    private JTextField m_chosenFile;

    public AddSoundBiteDialog(SantaSoundService santaSoundService, Window owner) {
        super(owner, "Add a sound bite", Dialog.ModalityType.APPLICATION_MODAL);
        this.m_santaSoundService = santaSoundService;
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        JPanel addControls = new JPanel(new FlowLayout());
        JButton chooseFile = new JButton("Choose file");
        addControls.add(new JLabel("Enter URL of sound bite on the web or "));
        addControls.add(chooseFile);
        this.m_chosenFile = new JTextField("http://", 30);
        chooseFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileFilter(new FileFilter(){

                        public String getDescription() {
                            return "audio file (*.wav,*.au,*.aif,*.mp3)";
                        }

                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            String name = f.getName().toLowerCase();
                            if (name.endsWith(".wav")) {
                                return true;
                            }
                            if (name.endsWith(".au")) {
                                return true;
                            }
                            if (name.endsWith(".aif")) {
                                return true;
                            }
                            return name.endsWith(".mp3");
                        }
                    });
                    int showOpenDialog = chooser.showOpenDialog(AddSoundBiteDialog.this);
                    if (showOpenDialog == 0) {
                        File selectedFile = chooser.getSelectedFile();
                        AddSoundBiteDialog.this.m_chosenFile.setText(selectedFile.getAbsolutePath());
                    }
                }
                catch (AccessControlException e) {
                    JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Sorry, access to local files is denied. Please use the URL method.");
                }
            }
        });
        addControls.add(this.m_chosenFile);
        JPanel namePanel = new JPanel();
        namePanel.add(new JLabel("Name:"));
        this.m_biteName = new JTextField(12);
        namePanel.add(this.m_biteName);
        addControls.add(namePanel);
        this.m_chosenFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.updateBiteName();
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateBiteName();
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateBiteName();
            }

            private void updateBiteName() {
                String derivedBiteName;
                if (AddSoundBiteDialog.this.isDerivedName() && (derivedBiteName = AddSoundBiteDialog.getDerivedBiteName(AddSoundBiteDialog.this.m_chosenFile.getText())) != null) {
                    AddSoundBiteDialog.this.m_biteName.setText(derivedBiteName);
                }
            }
        });
        JButton add = new JButton("Add to library");
        add.addActionListener(this.getAddActionListener());
        JButton test = new JButton("Test");
        test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddSoundBiteDialog.this.testSoundBite();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddSoundBiteDialog.this.setVisible(false);
            }
        });
        JPanel dialogControls = new JPanel();
        dialogControls.add(test);
        dialogControls.add(add);
        dialogControls.add(cancel);
        this.add((Component)addControls, "Center");
        this.add((Component)dialogControls, "South");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected void testSoundBite() {
        try {
            int read;
            byte[] audioData = this.getAudioData();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(audioData);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open();
            line.start();
            byte[] buffer = new byte[8096];
            while ((read = inputStream.read(buffer)) > 0) {
                line.write(buffer, 0, read);
            }
            line.drain();
            line.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to play sound : " + e.getMessage());
        }
    }

    protected static String getDerivedBiteName(String uri) {
        int slosh;
        int slash = uri.lastIndexOf(47);
        int nameOffset = Math.max(slash, slosh = uri.lastIndexOf(92));
        if (nameOffset >= 0 && uri.length() - nameOffset > 7) {
            return StringUtils.substring((String)uri, (int)(nameOffset + 1));
        }
        return null;
    }

    protected boolean isDerivedName() {
        return true;
    }

    private ActionListener getAddActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                byte[] audioData;
                try {
                    audioData = AddSoundBiteDialog.this.getAudioData();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Failed to load sound bite : " + e);
                    return;
                }
                ByteArrayInputStream checkStream = new ByteArrayInputStream(audioData);
                try {
                    AddSoundBiteDialog.checkSupported(checkStream);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Failed to load sound bite : " + e.getMessage());
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)checkStream);
                }
                String biteName = AddSoundBiteDialog.this.m_biteName.getText();
                if (StringUtils.isEmpty((String)biteName) || biteName.length() < 3) {
                    JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Bad sound bite name");
                    return;
                }
                SoundBiteTagsDialog soundBiteTagsDialog = new SoundBiteTagsDialog(biteName, AddSoundBiteDialog.this);
                soundBiteTagsDialog.setVisible(true);
                if (soundBiteTagsDialog.getResult() == 1) {
                    try {
                        AddSoundBiteDialog.this.m_santaSoundService.addSoundBite(audioData, biteName, soundBiteTagsDialog.getTags());
                    }
                    catch (UndeclaredThrowableException e) {
                        JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Unable to add sound bite : " + e.getCause().getMessage());
                    }
                    catch (SoundBiteException e) {
                        JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Unable to add sound bite : " + e.getMessage());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(AddSoundBiteDialog.this, "Unable to add sound bite : " + e.getMessage());
                    }
                    AddSoundBiteDialog.this.setVisible(false);
                }
            }
        };
    }

    public static void checkSupported(InputStream inputStream) {
        AudioInputStream audioInputStream = null;
        Line line = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
            line = (SourceDataLine)AudioSystem.getLine(info);
        }
        catch (UnsupportedAudioFileException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (LineUnavailableException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.toString());
        }
        finally {
            if (line != null) {
                line.close();
            }
            if (audioInputStream != null) {
                try {
                    audioInputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAudioData() throws IOException {
        InputStream audioInputStream;
        String chosenUrl = this.m_chosenFile.getText();
        if (chosenUrl.startsWith("http://")) {
            URL url = new URL(chosenUrl);
            URLConnection openConnection = url.openConnection();
            audioInputStream = openConnection.getInputStream();
        } else {
            audioInputStream = new FileInputStream(chosenUrl);
        }
        byte[] buffer = new byte[8096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int totalSize = 0;
        try {
            int read;
            while ((read = audioInputStream.read(buffer)) > 0) {
                if (totalSize + read > 262144) {
                    throw new IOException("Audio resource too large");
                }
                byteArrayOutputStream.write(buffer, 0, read);
                totalSize += read;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)audioInputStream);
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public SantaSoundService getSantaSoundService() {
        return this.m_santaSoundService;
    }
}

