/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.hurstfrost.santa.control.SantaControlService;
import net.hurstfrost.santa.sound.SantaSoundService;
import net.hurstfrost.santa.swing.SantaMotionPanel;
import net.hurstfrost.santa.swing.SantaSoundPanel;
import net.hurstfrost.santa.swing.SantaSpeechPanel;
import org.apache.log4j.Logger;

public class SantaFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(SantaFrame.class);

    public SantaFrame(SantaControlService santaControlService, SantaSoundService santaSoundService) {
        super("Santa Controller");
        InputStream iconResource = this.getClass().getClassLoader().getResourceAsStream("santaicon.png");
        if (iconResource != null) {
            try {
                this.setIconImage(ImageIO.read(iconResource));
            }
            catch (IOException e) {
                log.warn((Object)"Unable to load icon image", (Throwable)e);
            }
        } else {
            log.warn((Object)"Unable to load icon image");
        }
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)new SantaSpeechPanel(santaSoundService), "North");
        this.getContentPane().add((Component)new SantaSoundPanel(santaSoundService), "Center");
        this.getContentPane().add((Component)new SantaMotionPanel(santaControlService), "South");
        this.pack();
        this.setLocationByPlatform(true);
    }
}

