/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicBorders;
import net.hurstfrost.santa.control.SantaControlService;
import org.apache.log4j.Logger;

public class SantaMotionPanel
extends JPanel
implements MouseListener {
    private static final Logger log = Logger.getLogger(SantaMotionPanel.class);
    private JLabel m_mouth;
    private JLabel m_lookLeft;
    private JLabel m_lookRight;
    private JLabel m_wiggle;
    private final SantaControlService m_santaControlService;

    public SantaMotionPanel(SantaControlService santaControlService) {
        this.m_santaControlService = santaControlService;
        this.setLayout(new BorderLayout());
        this.m_mouth = new JLabel("Mouth", 0){

            public Dimension getPreferredSize() {
                return new Dimension(90, 32);
            }
        };
        this.m_lookLeft = new JLabel("Look left", 0){

            public Dimension getPreferredSize() {
                return new Dimension(90, 32);
            }
        };
        this.m_lookRight = new JLabel("Look right", 0){

            public Dimension getPreferredSize() {
                return new Dimension(90, 32);
            }
        };
        this.m_wiggle = new JLabel("Dance", 0){

            public Dimension getPreferredSize() {
                return new Dimension(90, 32);
            }
        };
        this.m_mouth.setBorder(BasicBorders.getButtonBorder());
        this.m_lookLeft.setBorder(BasicBorders.getButtonBorder());
        this.m_lookRight.setBorder(BasicBorders.getButtonBorder());
        this.m_wiggle.setBorder(BasicBorders.getButtonBorder());
        this.m_mouth.addMouseListener(this);
        this.m_lookLeft.addMouseListener(this);
        this.m_lookRight.addMouseListener(this);
        this.m_wiggle.addMouseListener(this);
        this.add((Component)this.m_mouth, "Center");
        this.add((Component)this.m_lookLeft, "West");
        this.add((Component)this.m_lookRight, "East");
        this.add((Component)this.m_wiggle, "South");
        this.setBorder(BorderFactory.createTitledBorder("Motion controls:"));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.m_mouth) {
            this.m_santaControlService.openMouth();
        } else if (e.getSource() == this.m_lookLeft) {
            this.m_santaControlService.turnLeft();
        } else if (e.getSource() == this.m_lookRight) {
            this.m_santaControlService.turnRight();
        } else if (e.getSource() == this.m_wiggle) {
            this.m_santaControlService.wiggleStart();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.m_mouth) {
            this.m_santaControlService.closeMouth();
        } else if (e.getSource() == this.m_lookLeft) {
            this.m_santaControlService.turnStop();
        } else if (e.getSource() == this.m_lookRight) {
            this.m_santaControlService.turnStop();
        } else if (e.getSource() == this.m_wiggle) {
            this.m_santaControlService.wiggleStop();
        }
    }
}

