/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.hurstfrost.santa.sound.SantaSoundService;
import net.hurstfrost.santa.swing.AddSoundBiteDialog;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SantaSoundPanel
extends JPanel {
    private static final String NO_SOUND_BITES_FOUND = "No sound bites found";
    private static final Logger log = Logger.getLogger(SantaSoundPanel.class);

    public SantaSoundPanel(final SantaSoundService santaSoundService) {
        JPanel lookupPanel = new JPanel(new GridLayout(2, 1));
        final JTextField tags = new JTextField(20);
        tags.setToolTipText("Type a search query for sound bite. Examples: 'all','sneeze','yawn','human','all NOT human'");
        final JComboBox<Object> soundSelect = new JComboBox<Object>(new Object[]{NO_SOUND_BITES_FOUND});
        soundSelect.setEnabled(false);
        final JButton play = new JButton("Play");
        play.setEnabled(false);
        JButton add = new JButton("Add...");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddSoundBiteDialog dialog = new AddSoundBiteDialog(santaSoundService, SantaSoundPanel.this.getWindow());
                dialog.setVisible(true);
            }
        });
        tags.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                soundSelect.removeAllItems();
                soundSelect.setEnabled(false);
                play.setEnabled(false);
                soundSelect.addItem(SantaSoundPanel.NO_SOUND_BITES_FOUND);
                try {
                    List sounds = santaSoundService.getSounds(tags.getText());
                    if (!sounds.isEmpty()) {
                        soundSelect.removeAllItems();
                        for (String sound : sounds) {
                            soundSelect.addItem(sound);
                        }
                        soundSelect.setEnabled(true);
                        play.setEnabled(true);
                    } else {
                        log.debug((Object)"Search returned no items");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Lookup failed", (Throwable)e);
                }
            }
        });
        JPanel p1 = new JPanel(new FlowLayout());
        p1.add(tags);
        lookupPanel.add(p1);
        JPanel p2 = new JPanel(new FlowLayout());
        p2.add(soundSelect);
        play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)soundSelect.getSelectedItem();
                if (!StringUtils.isEmpty((String)selectedItem)) {
                    santaSoundService.play(selectedItem);
                }
            }
        });
        p2.add(play);
        p2.add(add);
        lookupPanel.add(p2);
        this.add(lookupPanel);
        this.setBorder(BorderFactory.createTitledBorder("Sound controls:"));
    }

    protected Window getWindow() {
        Container parent = this;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }
}

