/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import net.hurstfrost.santa.sound.SantaSoundService;
import net.hurstfrost.santa.sound.SantaVoice;
import org.apache.log4j.Logger;

public class SantaSpeechPanel
extends JPanel
implements ActionListener {
    private static final Logger log = Logger.getLogger(SantaSpeechPanel.class);
    private final SantaSoundService m_santaSoundService;
    private JButton m_talkButton;
    private JTextArea m_text;
    private JComboBox m_voiceChoice;

    public SantaSpeechPanel(SantaSoundService santaControlService) {
        this.m_santaSoundService = santaControlService;
        this.setLayout(new BorderLayout());
        List voices = this.m_santaSoundService.getVoices();
        this.m_text = new JTextArea();
        this.m_text.setWrapStyleWord(true);
        this.m_text.setLineWrap(true);
        this.m_text.setSelectionColor(Color.LIGHT_GRAY);
        this.add((Component)this.m_text, "Center");
        this.m_voiceChoice = new JComboBox<SantaVoice>(voices.toArray(new SantaVoice[0]));
        this.m_voiceChoice.setFont(Font.decode("Arial-10"));
        this.add((Component)this.m_voiceChoice, "North");
        this.m_voiceChoice.addActionListener(this);
        this.m_voiceChoice.setRenderer(new VoiceComboRenderer());
        this.m_talkButton = new JButton("Talk");
        this.add((Component)this.m_talkButton, "South");
        this.m_talkButton.addActionListener(this);
        this.setBorder(BorderFactory.createTitledBorder("Voice controls:"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_talkButton) {
            String text = this.m_text.getSelectedText();
            if (text == null) {
                text = this.m_text.getText();
            }
            if (text != null && text.length() > 0) {
                log.debug((Object)("Say '" + text + "' using " + this.m_voiceChoice.getSelectedItem()));
                this.m_santaSoundService.speak(text, false, ((SantaVoice)this.m_voiceChoice.getSelectedItem()).getId());
            }
            this.m_text.grabFocus();
        }
    }

    private static class VoiceComboRenderer
    extends JLabel
    implements ListCellRenderer {
        public VoiceComboRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color foreground;
            Color background;
            if (value instanceof SantaVoice) {
                SantaVoice voice = (SantaVoice)value;
                this.setText(voice.getName());
            } else {
                this.setText(value.toString());
            }
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
                background = Color.BLUE;
                foreground = Color.WHITE;
            } else if (isSelected) {
                background = Color.RED;
                foreground = Color.WHITE;
            } else {
                background = Color.WHITE;
                foreground = Color.BLACK;
            }
            this.setBackground(background);
            this.setForeground(foreground);
            return this;
        }
    }
}

