/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.santa.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SoundBiteTagsDialog
extends JDialog {
    private static final int CANCEL = 0;
    static final int UPLOAD = 1;
    private int m_result;
    private String[] m_tags;

    public SoundBiteTagsDialog(String biteName, Window owner) {
        super(owner, "Enter tags for " + biteName, Dialog.ModalityType.APPLICATION_MODAL);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 200));
        this.setLocationRelativeTo(owner);
        JPanel controlsPanel = new JPanel(new FlowLayout());
        controlsPanel.add(new JLabel("Please enter as many simple words that"));
        controlsPanel.add(new JLabel("categorise this sound bite as possible."));
        final JTextField tagsTextField = new JTextField(20);
        controlsPanel.add(tagsTextField);
        this.add((Component)controlsPanel, "Center");
        JButton upload = new JButton("Upload");
        upload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String tags = tagsTextField.getText();
                if (!SoundBiteTagsDialog.isAllLetters(tags)) {
                    JOptionPane.showMessageDialog(SoundBiteTagsDialog.this, "Please only enter space delimited simple words.");
                    return;
                }
                SoundBiteTagsDialog.access$102(SoundBiteTagsDialog.this, SoundBiteTagsDialog.getTags(tags));
                if (SoundBiteTagsDialog.countGoodTags(SoundBiteTagsDialog.this.m_tags) < 2) {
                    JOptionPane.showMessageDialog(SoundBiteTagsDialog.this, "Please enter at least two 4-letter tags.");
                    return;
                }
                SoundBiteTagsDialog.this.setComplete(1);
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoundBiteTagsDialog.this.setComplete(0);
            }
        });
        JPanel uploadPanel = new JPanel(new FlowLayout());
        uploadPanel.add(upload);
        uploadPanel.add(cancel);
        this.add((Component)uploadPanel, "South");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected static String[] getTags(String tags) {
        String[] split = tags.split(" +");
        List<String> list = Arrays.asList(split);
        HashSet<String> set = new HashSet<String>(list);
        return set.toArray(new String[0]);
    }

    private static boolean isAllLetters(String tags) {
        for (int i = 0; i < tags.length(); ++i) {
            if (tags.charAt(i) == ' ' || Character.isLetter(tags.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int countGoodTags(String[] tags) {
        int count = 0;
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].length() <= 3) continue;
            ++count;
        }
        return count;
    }

    protected void setComplete(int result) {
        this.m_result = result;
        this.setVisible(false);
    }

    public int getResult() {
        return this.m_result;
    }

    public String[] getTags() {
        return this.m_tags;
    }

    static /* synthetic */ String[] access$102(SoundBiteTagsDialog x0, String[] x1) {
        x0.m_tags = x1;
        return x1;
    }
}

