/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.appshare.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import net.hurstfrost.appshare.entity.Installer;

@Entity
public class Device
implements Serializable {
    @Id
    private String udid;
    @OneToMany
    private Set<Installer> installations;
    private String locale;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSeen;

    public Device() {
    }

    public Device(String _udid) {
        this.udid = _udid;
    }

    @PrePersist
    @PreUpdate
    void prePersist() {
        this.lastSeen = new Date();
    }

    public Set<Installer> getInstallations() {
        return this.installations;
    }

    public void addInstallation(Installer installation) {
        if (this.installations == null) {
            this.installations = new HashSet();
        }
        this.installations.add(installation);
    }

    public String getUdid() {
        return this.udid;
    }

    public void setUdid(String _udid) {
        this.udid = _udid;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String _locale) {
        this.locale = _locale;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Date _lastSeen) {
        this.lastSeen = _lastSeen;
    }

    public String toString() {
        return this.udid;
    }
}

