/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.appshare.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import net.hurstfrost.appshare.entity.Application;
import net.hurstfrost.appshare.entity.Device;
import net.hurstfrost.appshare.entity.ShareSuggestion;

@Entity
public class Installer
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long id;
    private String email;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date registered;
    private String fullName;
    private Device device;
    @JoinColumn(nullable=false)
    private Application application;
    private boolean thirdParty;
    @ManyToMany
    private Set<ShareSuggestion> shares;

    public Installer() {
    }

    public Installer(Device _device, Application _application, String _email) {
        this.device = _device;
        this.application = _application;
        this.email = _email;
    }

    @PrePersist
    void prePersist() {
        this.created = new Date();
    }

    public boolean isThirdParty() {
        return this.thirdParty;
    }

    public void setThirdParty(boolean _thirdParty) {
        this.thirdParty = _thirdParty;
    }

    public Set<ShareSuggestion> getShares() {
        return this.shares;
    }

    public void setShares(Set<ShareSuggestion> _shares) {
        this.shares = _shares;
    }

    public Device getDevice() {
        return this.device;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getRegistered() {
        return this.registered;
    }

    public Application getApplication() {
        return this.application;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String _email) {
        this.email = _email;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.application.toString() + " on " + this.device + " by " + this.email;
    }

    public ShareSuggestion getShares(String friendEmail) {
        for (ShareSuggestion s : this.shares) {
            if (!s.getEmail().equals(friendEmail)) continue;
            return s;
        }
        return null;
    }

    public void addShare(ShareSuggestion suggestion) {
        this.shares.add(suggestion);
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String _fullName) {
        this.fullName = _fullName;
    }
}

