/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.appshare.service;

import java.util.Collection;
import java.util.List;
import net.hurstfrost.appshare.entity.Application;
import net.hurstfrost.appshare.entity.Device;
import net.hurstfrost.appshare.entity.Installer;
import net.hurstfrost.appshare.entity.ShareSuggestion;
import net.hurstfrost.appshare.service.PersistenceService;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PersistenceServiceImpl
extends JpaDaoSupport
implements PersistenceService {
    public Device getDevice(String udid) {
        List find = this.getJpaTemplate().find("select d from Device d where d.udid=?1", new Object[]{udid.toUpperCase()});
        if (find.size() == 0) {
            return null;
        }
        if (find.size() == 1) {
            return (Device)find.get(0);
        }
        throw new IllegalStateException();
    }

    public ShareSuggestion getSuggestion(String token) {
        List find = this.getJpaTemplate().find("select s from ShareSuggestion s where s.token=?1", new Object[]{token});
        if (find.size() == 0) {
            return null;
        }
        if (find.size() == 1) {
            return (ShareSuggestion)find.get(0);
        }
        throw new IllegalStateException("More than one ShareSuggestion with the token '" + token + "'");
    }

    public Collection<Application> getApplications() {
        return this.getJpaTemplate().find("select a from Application a");
    }

    public Collection<Device> getDevices() {
        return this.getJpaTemplate().find("select d from Device d");
    }

    public Application getApplication(String appId) {
        List find = this.getJpaTemplate().find("select a from Application a where a.id=?1", new Object[]{appId});
        if (find.size() == 0) {
            return null;
        }
        if (find.size() == 1) {
            return (Application)find.get(0);
        }
        throw new IllegalStateException();
    }

    public ShareSuggestion update(ShareSuggestion shareSuggestion) {
        return (ShareSuggestion)this.getJpaTemplate().merge((Object)shareSuggestion);
    }

    public Application update(Application application) {
        return (Application)this.getJpaTemplate().merge((Object)application);
    }

    public void delete(Application application) {
        this.getJpaTemplate().remove(this.getJpaTemplate().merge((Object)application));
    }

    public Device getDevice(String udid, boolean create) {
        List find = this.getJpaTemplate().find("select d from Device d where d.udid=?1", new Object[]{udid});
        if (find.size() == 0) {
            if (create) {
                Device device = new Device(udid);
                this.getJpaTemplate().persist((Object)device);
                return device;
            }
            return null;
        }
        if (find.size() == 1) {
            return (Device)find.get(0);
        }
        throw new IllegalStateException();
    }

    public Installer getInstallerByEmail(String email, Device device, Application application, boolean create) {
        List find = this.getJpaTemplate().find("select i from Installer i where i.email=?1 and i.device=?2 and i.application=?3", new Object[]{email, device, application});
        if (find.size() == 0) {
            if (create) {
                Installer installer = new Installer(device, application, email);
                this.getJpaTemplate().persist((Object)installer);
                return installer;
            }
            return null;
        }
        if (find.size() == 1) {
            return (Installer)find.get(0);
        }
        throw new IllegalStateException();
    }

    public Collection<Installer> getInstallers(Application application) {
        return this.getJpaTemplate().find("select i from Installer i where i.application=?1", new Object[]{application});
    }

    public void add(Application application) {
        this.getJpaTemplate().persist((Object)application);
    }

    public Installer update(Installer installer) {
        return (Installer)this.getJpaTemplate().merge((Object)installer);
    }

    public void persist(Installer registration) {
        this.getJpaTemplate().persist((Object)registration);
    }

    public Device update(Device device) {
        return (Device)this.getJpaTemplate().merge((Object)device);
    }
}

