/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.appshare.web.controller;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hurstfrost.appshare.entity.Application;
import net.hurstfrost.appshare.entity.Device;
import net.hurstfrost.appshare.entity.Installer;
import net.hurstfrost.appshare.entity.ShareSuggestion;
import net.hurstfrost.appshare.service.PersistenceService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RegisterController
extends AbstractController {
    private static Logger log = Logger.getLogger(RegisterController.class);
    private PersistenceService persistenceService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String udid = request.getParameter("udid");
        String locale = request.getParameter("locale");
        String token = request.getParameter("token");
        String name = request.getParameter("name");
        String email = request.getParameter("email");
        String appId = request.getParameter("appId");
        if (StringUtils.isEmpty((String)udid) || StringUtils.isEmpty((String)locale) || StringUtils.isEmpty((String)token) || StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)email) || StringUtils.isEmpty((String)appId)) {
            log.info((Object)("Incomplete request " + request.getQueryString()));
            return null;
        }
        ShareSuggestion shareSuggestion = this.persistenceService.getSuggestion(token);
        if (shareSuggestion == null) {
            log.info((Object)("Bad token " + request.getQueryString()));
            return null;
        }
        Installer proposer = shareSuggestion.getProposer();
        Application application = proposer.getApplication();
        if (!appId.equals(application.getId())) {
            log.info((Object)("Invalid App ID " + request.getQueryString()));
            return null;
        }
        Device device = this.persistenceService.getDevice(udid, true);
        device.setLastSeen(new Date());
        device.setLocale(locale);
        Installer registration = this.persistenceService.getInstallerByEmail(email, device, application, false);
        ModelAndView mav = new ModelAndView("register_result");
        String result = null;
        if (registration == null) {
            registration = new Installer(device, application, email);
            registration.setFullName(name);
            this.persistenceService.persist(registration);
            result = "Registered";
        } else {
            result = "Already registered";
        }
        shareSuggestion.setRegistration(registration);
        this.persistenceService.update(shareSuggestion);
        this.persistenceService.update(device);
        mav.addObject("result", (Object)result);
        return mav;
    }

    public void setPersistenceService(PersistenceService _persistenceService) {
        this.persistenceService = _persistenceService;
    }
}

