/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.appshare.web.controller;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hurstfrost.appshare.entity.Application;
import net.hurstfrost.appshare.entity.Device;
import net.hurstfrost.appshare.entity.Installer;
import net.hurstfrost.appshare.entity.ShareSuggestion;
import net.hurstfrost.appshare.service.EmailSenderService;
import net.hurstfrost.appshare.service.PersistenceService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ShareController
extends AbstractController {
    private static Logger log = Logger.getLogger(ShareController.class);
    private PersistenceService persistenceService;
    private EmailSenderService emailSender;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String udid = request.getParameter("udid");
        String locale = request.getParameter("locale");
        String appId = request.getParameter("appId");
        String ownerEmail = request.getParameter("owner");
        String ownerName = request.getParameter("name");
        String friendEmail = request.getParameter("friend");
        if (StringUtils.isEmpty((String)udid) || StringUtils.isEmpty((String)locale) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)ownerEmail) || StringUtils.isEmpty((String)friendEmail)) {
            log.info((Object)("Incomplete request " + request.getQueryString()));
            return null;
        }
        Device device = this.persistenceService.getDevice(udid, true);
        if (!locale.equals(device.getLocale())) {
            device.setLocale(locale);
        }
        device.setLastSeen(new Date());
        Application application = this.persistenceService.getApplication(appId);
        ModelAndView mav = new ModelAndView("share_result");
        String result = null;
        if (device != null && application != null) {
            ShareSuggestion suggestion;
            Installer proposer = this.persistenceService.getInstallerByEmail(ownerEmail, device, application, true);
            device.addInstallation(proposer);
            if (ownerName != null) {
                proposer.setFullName(ownerName);
            }
            if ((suggestion = proposer.getShares(friendEmail)) == null) {
                suggestion = new ShareSuggestion(friendEmail, proposer);
                proposer.addShare(suggestion);
            }
            if (this.emailSender.sendShareEmail(application, proposer = this.persistenceService.update(proposer), suggestion = proposer.getShares(friendEmail))) {
                this.persistenceService.update(suggestion);
                result = "Email sent";
                this.persistenceService.update(proposer);
                log.info((Object)("Email sent to " + friendEmail));
            } else {
                result = "Email not sent";
                response.sendError(503);
                log.info((Object)("Email not sent to " + friendEmail));
                mav = null;
            }
        } else {
            result = "Missing device or application";
            log.info((Object)"Invalid request (missing parameters)");
        }
        device = this.persistenceService.update(device);
        if (mav != null) {
            mav.addObject("result", (Object)result);
        }
        return mav;
    }

    public void setPersistenceService(PersistenceService _persistenceService) {
        this.persistenceService = _persistenceService;
    }

    public void setEmailSenderService(EmailSenderService _emailSender) {
        this.emailSender = _emailSender;
    }
}

