<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"
%><html>
<body>
<h1>ADMIN</h1>
<h2>Applications</h2>
<table border="1">
<tr><td>ID</td><td>Name</td><td>Description</td><td>Thumbnail</td><td>iTunes URL</td><td>Edit</td></tr>
<c:forEach var="app" items="${apps}">
<tr>
<td><a href="<c:url value="installers.htm"><c:param name="appId" value="${app.id}"/></c:url>">${app.id}</a></td>
<td>${app.name}</td>
<td>${app.description}</td>
<td align="center"><c:choose><c:when test="${not empty app.thumbUrl}"><img src="${app.thumbUrl}"></c:when><c:otherwise>Missing!</c:otherwise></c:choose></td>
<td><c:choose><c:when test="${not empty app.iTunesUrl}"><a href="${app.iTunesUrl}">Test</a></c:when><c:otherwise>Missing!</c:otherwise></c:choose></td>
<td><a href="<c:url value="edit_application.htm"><c:param name="appId" value="${app.id}"/></c:url>">Edit</a></td>
</tr>
</c:forEach>
</table>
<a href="add_application.htm">Add application</a>
<h2>Devices</h2>
<table border="1">
<tr><td>UDID</td><td>Locale</td><td>Last seen</td></tr>
<c:forEach var="device" items="${devices}">
	<tr>
		<td>${device.udid}</td>
		<td>${device.locale}</td>
		<td>${device.lastSeen}</td>
		<td>
			<c:forEach var="inst" items="${device.installations}" varStatus="s">
				<a href="<c:url value="installers.htm"><c:param name="appId" value="${inst.application.id}"/></c:url>">${inst.application.name}</a><c:if test="${not s.last}">,</c:if>
			</c:forEach>
		</td>
	</tr>
</c:forEach>
</table>
</body>
</html>