/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import java.awt.Dimension;
import net.hurstfrost.jdomhtml.AutoBorderManager;
import net.hurstfrost.jdomhtml.TableDecoration;

public class AutoBorder
implements TableDecoration {
    private String m_name;
    private String m_pathToImages;
    private Dimension m_dimension;
    private int m_cornerMode;
    private int m_edgeMode;
    private static int SINGLE_CORNER = 1;
    private static int FOUR_CORNERS = 2;
    private static int SINGLE_EDGE = 1;
    private static int TWO_EDGES = 2;
    private static int FOUR_EDGES = 3;

    public AutoBorder(String name, String pathToImages, Dimension dimension) {
        this.m_name = name;
        this.m_pathToImages = pathToImages;
        this.m_dimension = dimension;
    }

    public void setSingleCorner() {
        this.m_cornerMode = SINGLE_CORNER;
    }

    public void setFourCorners() {
        this.m_cornerMode = FOUR_CORNERS;
    }

    public void setSingleEdge() {
        this.m_edgeMode = SINGLE_EDGE;
    }

    public void setTwoEdges() {
        this.m_edgeMode = TWO_EDGES;
    }

    public void setFourEdges() {
        this.m_edgeMode = FOUR_EDGES;
    }

    private String getImageName(int type) {
        return this.m_pathToImages + this.m_name + "_" + AutoBorderManager.Endings.ENDINGS[type] + ".gif";
    }

    @Override
    public String topLeft() {
        if (this.m_cornerMode == SINGLE_CORNER) {
            return this.getImageName(10);
        }
        if (this.m_cornerMode == FOUR_CORNERS) {
            return this.getImageName(0);
        }
        return null;
    }

    @Override
    public String topRight() {
        if (this.m_cornerMode == SINGLE_CORNER) {
            return this.getImageName(10);
        }
        if (this.m_cornerMode == FOUR_CORNERS) {
            return this.getImageName(1);
        }
        return null;
    }

    @Override
    public String bottomLeft() {
        if (this.m_cornerMode == SINGLE_CORNER) {
            return this.getImageName(10);
        }
        if (this.m_cornerMode == FOUR_CORNERS) {
            return this.getImageName(2);
        }
        return null;
    }

    @Override
    public String bottomRight() {
        if (this.m_cornerMode == SINGLE_CORNER) {
            return this.getImageName(10);
        }
        if (this.m_cornerMode == FOUR_CORNERS) {
            return this.getImageName(3);
        }
        return null;
    }

    @Override
    public String top() {
        if (this.m_edgeMode == SINGLE_EDGE) {
            return this.getImageName(11);
        }
        if (this.m_edgeMode == TWO_EDGES) {
            return this.getImageName(8);
        }
        if (this.m_edgeMode == FOUR_EDGES) {
            return this.getImageName(4);
        }
        return null;
    }

    @Override
    public String left() {
        if (this.m_edgeMode == SINGLE_EDGE) {
            return this.getImageName(11);
        }
        if (this.m_edgeMode == TWO_EDGES) {
            return this.getImageName(9);
        }
        if (this.m_edgeMode == FOUR_EDGES) {
            return this.getImageName(6);
        }
        return null;
    }

    @Override
    public String bottom() {
        if (this.m_edgeMode == SINGLE_EDGE) {
            return this.getImageName(11);
        }
        if (this.m_edgeMode == TWO_EDGES) {
            return this.getImageName(8);
        }
        if (this.m_edgeMode == FOUR_EDGES) {
            return this.getImageName(5);
        }
        return null;
    }

    @Override
    public String right() {
        if (this.m_edgeMode == SINGLE_EDGE) {
            return this.getImageName(11);
        }
        if (this.m_edgeMode == TWO_EDGES) {
            return this.getImageName(9);
        }
        if (this.m_edgeMode == FOUR_EDGES) {
            return this.getImageName(7);
        }
        return null;
    }

    @Override
    public String vertical() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String horizontal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String topT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String leftT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String bottomT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String rightT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String cross() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int width() {
        return (int)this.m_dimension.getWidth();
    }

    @Override
    public int height() {
        return (int)this.m_dimension.getHeight();
    }

    @Override
    public String getName() {
        return this.m_name;
    }
}

