/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.hurstfrost.jdomhtml.AutoBorder;

public class AutoBorderManager {
    public static void loadBorders(File fileRoot, String webRoot, String pathToImages, Map toMap) {
        Set<String> imageDesc;
        HashMap imageDescriptions = new HashMap();
        HashMap<String, Dimension> imageSizes = new HashMap<String, Dimension>();
        File imagePath = new File(fileRoot, pathToImages);
        File[] files = imagePath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.toLowerCase().endsWith(".gif");
            }
        });
        if (files == null) {
            System.err.println("No border definitions found in " + imagePath.getAbsolutePath());
            return;
        }
        while (webRoot.endsWith("/") || webRoot.endsWith("\\")) {
            webRoot = webRoot.substring(0, webRoot.length() - 1);
        }
        webRoot = webRoot + "/";
        while (pathToImages.startsWith("/") || pathToImages.startsWith("\\")) {
            pathToImages = pathToImages.substring(1);
        }
        while (pathToImages.endsWith("/") || pathToImages.endsWith("\\")) {
            pathToImages = pathToImages.substring(0, pathToImages.length() - 1);
        }
        pathToImages = pathToImages + "/";
        block3: for (int i = 0; i < files.length; ++i) {
            String imageName = files[i].getName().substring(0, files[i].getName().length() - 4);
            for (int e = 0; e < Endings.ENDINGS.length; ++e) {
                if (!imageName.endsWith("_" + Endings.ENDINGS[e])) continue;
                String borderName = imageName.substring(0, imageName.length() - Endings.ENDINGS[e].length() - 1);
                imageDesc = (Set)imageDescriptions.get(borderName);
                if (imageDesc == null) {
                    imageDesc = new HashSet<String>();
                    imageDescriptions.put(borderName, imageDesc);
                }
                Dimension borderDim = (Dimension)imageSizes.get(borderName);
                imageDesc.add(Endings.ENDINGS[e]);
                Dimension imageDim = AutoBorderManager.getGIFSize(files[i]);
                if (e != 0 && (borderDim != null || e != 10)) continue block3;
                imageSizes.put(borderName, imageDim);
                continue block3;
            }
        }
        for (String borderName : imageDescriptions.keySet()) {
            boolean hasFourSides;
            imageDesc = (HashSet<String>)imageDescriptions.get(borderName);
            Dimension imageDim = (Dimension)imageSizes.get(borderName);
            boolean hasFourCorners = imageDesc.contains(Endings.ENDINGS[0]) && imageDesc.contains(Endings.ENDINGS[1]) && imageDesc.contains(Endings.ENDINGS[2]) && imageDesc.contains(Endings.ENDINGS[3]);
            boolean hasSingleCorner = imageDesc.contains(Endings.ENDINGS[10]);
            boolean hasEdge = imageDesc.contains(Endings.ENDINGS[11]);
            boolean hasSides = imageDesc.contains(Endings.ENDINGS[8]) && imageDesc.contains(Endings.ENDINGS[9]);
            boolean bl = hasFourSides = imageDesc.contains(Endings.ENDINGS[4]) && imageDesc.contains(Endings.ENDINGS[5]) && imageDesc.contains(Endings.ENDINGS[6]) && imageDesc.contains(Endings.ENDINGS[7]);
            if (hasFourCorners && hasSingleCorner) {
                System.err.println("Table decoration " + borderName + " specifies corners ambiguoiusly");
                continue;
            }
            if (hasEdge && hasSides || hasSides && hasFourSides || hasEdge && hasFourSides) {
                System.err.println("Table decoration " + borderName + " specifies edges ambiguoiusly");
                continue;
            }
            if (!hasFourCorners && !hasSingleCorner) {
                System.err.println("Table decoration " + borderName + " does not specify corners");
                continue;
            }
            if (!(hasEdge || hasSides || hasFourSides)) {
                System.err.println("Table decoration " + borderName + " does not specify edges");
                continue;
            }
            AutoBorder decoration = new AutoBorder(borderName, webRoot + pathToImages, imageDim);
            if (hasSingleCorner) {
                decoration.setSingleCorner();
            } else {
                decoration.setFourCorners();
            }
            if (hasEdge) {
                decoration.setSingleEdge();
            } else if (hasSides) {
                decoration.setTwoEdges();
            } else {
                decoration.setFourEdges();
            }
            toMap.put(decoration.getName(), decoration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getGIFSize(File file) {
        byte[] height;
        byte[] width;
        Dimension size = null;
        FileInputStream fin = null;
        DataInputStream din = null;
        try {
            fin = new FileInputStream(file);
            din = new DataInputStream(fin);
            byte[] signature = new byte[6];
            width = new byte[2];
            height = new byte[2];
            din.read(signature);
            din.read(width);
            din.read(height);
        }
        catch (Exception e) {
            Dimension dimension = null;
            return dimension;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {}
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException e) {}
        }
        size = new Dimension(width[0] + (width[1] << 8), height[0] + (height[1] << 8));
        return size;
    }

    public static void main(String[] args) {
        HashMap borders = new HashMap();
        AutoBorderManager.loadBorders(new File("D:/Java/eclipse/workspace/Gallery/web"), "", "/images/borders", borders);
    }

    static interface Endings {
        public static final int TOP_LEFT = 0;
        public static final int TOP_RIGHT = 1;
        public static final int BOT_LEFT = 2;
        public static final int BOT_RIGHT = 3;
        public static final int TOP = 4;
        public static final int BOT = 5;
        public static final int LEFT = 6;
        public static final int RIGHT = 7;
        public static final int HORI = 8;
        public static final int VERT = 9;
        public static final int CORN = 10;
        public static final int EDGE = 11;
        public static final int CROSS = 12;
        public static final String[] ENDINGS = new String[]{"TL", "TR", "BL", "BR", "T", "B", "L", "R", "H", "V", "C", "E", "X"};
    }
}

