/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.hurstfrost.jdomhtml.HTMLElement;
import net.hurstfrost.jdomhtml.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class Channel
extends HTMLElement {
    private static DateFormat o_dateFormattor = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");

    public Channel() {
        super("CHANNEL");
        new Document((Element)this);
        this.setAttribute("PRECACHE", "Yes");
        this.setAttribute("LASTMOD", o_dateFormattor.format(new Date()));
    }

    public Channel(String p_title) {
        this();
        this.addContent(new Element("TITLE").addContent(p_title));
    }

    public Channel(URL p_base, String p_title) {
        this();
        this.setAttribute("BASE", p_base.toString());
        this.addContent(new Element("TITLE").addContent(p_title));
    }

    public Channel(URL p_base, URL p_href, String p_title) {
        this(p_base, p_title);
        this.setAttribute("HREF", p_href.toString());
    }

    public void addItem(Item p_item) {
        this.addContent(p_item);
    }

    public void setLogin() {
        this.addContent(new Element("LOGIN"));
    }

    public void setPrecache(int p_level) {
        this.setAttribute("PRECACHE", "Yes");
        this.setAttribute("LEVEL", "" + p_level);
    }

    public void writeTo(OutputStream p_out) throws IOException {
        XMLOutputter x_outputter = new XMLOutputter(" ", true);
        x_outputter.output(this.getDocument(), p_out);
    }

    public static class Usage
    extends Element {
        public static final String DESKTOP = "DesktopComponent";
        public static final String SCREENSAVER = "ScreenSaver";

        public Usage(String p_type) {
            super("USAGE");
            this.setAttribute("VALUE", p_type);
        }

        public Usage(String p_type, int p_width, int p_height) {
            super("USAGE");
            this.setAttribute("VALUE", p_type);
            this.addContent(new Element("WIDTH").setAttribute("VALUE", "" + p_width));
            this.addContent(new Element("HEIGHT").setAttribute("VALUE", "" + p_height));
        }
    }

    public static class Item
    extends Element {
        public Item(URL p_href, String p_title) {
            super("ITEM");
            this.setAttribute("HREF", p_href.toString());
            this.setAttribute("LASTMOD", o_dateFormattor.format(new Date()));
            this.setAttribute("PRECACHE", "Yes");
            this.addContent(new Element("TITLE").addContent(p_title));
        }
    }
}

