/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class HTMLElement
extends Element {
    public static final String A_ONCLICK = "onclick";
    public static final String A_BORDER = "border";
    Stack o_contentStack;

    public HTMLElement() {
    }

    public HTMLElement(String p_name) {
        super(p_name);
    }

    public HTMLElement pushContent(Element p_element) {
        this.addContent(p_element);
        if (this.o_contentStack == null) {
            this.o_contentStack = new Stack();
        }
        this.o_contentStack.push(p_element);
        return (HTMLElement)p_element;
    }

    public HTMLElement addContent(HTMLElement p_element) {
        if (this.o_contentStack == null || this.o_contentStack.isEmpty()) {
            return (HTMLElement)super.addContent((Element)p_element);
        }
        ((HTMLElement)((Object)this.o_contentStack.peek())).addContent(p_element);
        return p_element;
    }

    public Element addContent(Element p_element) {
        if (this.o_contentStack == null || this.o_contentStack.isEmpty()) {
            return (HTMLElement)super.addContent(p_element);
        }
        ((HTMLElement)((Object)this.o_contentStack.peek())).addContent(p_element);
        return p_element;
    }

    public Element addContent(String p_element) {
        if (this.o_contentStack == null || this.o_contentStack.isEmpty()) {
            return (HTMLElement)super.addContent(p_element);
        }
        ((HTMLElement)((Object)this.o_contentStack.peek())).addContent(p_element);
        return this;
    }

    public HTMLElement pop() {
        return (HTMLElement)((Object)this.o_contentStack.pop());
    }

    public HTMLElement pop(Class p_elementClass) {
        HTMLElement x_element = (HTMLElement)((Object)this.o_contentStack.pop());
        if (x_element == null) {
            throw new RuntimeException("No element on pop " + p_elementClass.getName());
        }
        if (((Object)((Object)x_element)).getClass() != p_elementClass) {
            throw new RuntimeException("Class mismatch on pop " + p_elementClass.getName() + ", popped " + ((Object)((Object)x_element)).getClass().getName());
        }
        return x_element;
    }

    public HTMLElement addText(String p_string) {
        if (this.o_contentStack == null || this.o_contentStack.isEmpty()) {
            return (HTMLElement)super.addContent(p_string);
        }
        return ((HTMLElement)((Object)this.o_contentStack.peek())).addText(p_string);
    }

    public HTMLElement currentElement() {
        if (this.o_contentStack == null || this.o_contentStack.isEmpty()) {
            return this;
        }
        return (HTMLElement)((Object)this.o_contentStack.peek());
    }

    public HTMLElement setAttribute(String p_attr, Color p_colour) {
        return (HTMLElement)this.setAttribute(p_attr, "#" + Integer.toHexString(p_colour.getRGB() & 0xFFFFFF));
    }

    public void newParagraph() {
        this.addContent(new HTMLElement("p"));
    }

    public String toString() {
        StringWriter x_writer = new StringWriter();
        try {
            new XMLOutputter("  ", true).output((Element)this, (Writer)x_writer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
        return x_writer.getBuffer().toString();
    }
}

