/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import net.hurstfrost.jdomhtml.HTMLElement;
import net.hurstfrost.jdomhtml.URL;

public class Input
extends HTMLElement {
    public static final int SUBMIT = 0;
    public static final int BUTTON = 1;
    public static final int TEXT = 2;
    public static final int HIDDEN = 3;
    public static final int CHECKBOX = 4;
    public static final int FILE = 5;
    public static final int IMAGE = 6;
    public static final int RADIO = 7;
    private static final String[] TYPES = new String[]{"submit", "button", "text", "hidden", "checkbox", "file", "image", "radio"};

    public Input(int p_type, String p_name) {
        super("input");
        this.setAttribute("type", TYPES[p_type]);
        if (p_name != null) {
            this.setAttribute("name", p_name);
        }
    }

    public Input(int p_type, String p_name, String p_value) {
        this(p_type, p_name);
        this.setAttribute("type", TYPES[p_type]);
        this.setAttribute("value", p_value);
    }

    public HTMLElement setChecked(boolean p_checked) {
        if (p_checked) {
            this.setAttribute("checked", "1");
        }
        return this;
    }

    public Input(String p_name, URL p_image) {
        this(6, p_name);
        this.setAttribute("src", p_image.toString());
        this.setAttribute("border", "0");
    }
}

