/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import net.hurstfrost.jdomhtml.HTMLElement;
import net.hurstfrost.jdomhtml.Image;
import net.hurstfrost.jdomhtml.TD;
import net.hurstfrost.jdomhtml.TR;

public class Table
extends HTMLElement {
    public Table() {
        super("table");
    }

    public Table(int p_border) {
        this();
        this.setBorder(p_border);
    }

    public Table(String[] p_titles) {
        this();
        this.addContent(new TR(p_titles));
    }

    public Table(int p_border, String[] p_titles) {
        this(p_border);
        this.addContent(new TR(p_titles));
    }

    public Table(TR p_row) {
        this();
        this.addContent(p_row);
    }

    public void setSpacing(int spacing, int padding) {
        this.setAttribute("cellspacing", "" + spacing);
        this.setAttribute("cellpadding", "" + padding);
    }

    public Table(TD[][] p_contents) {
        this(0);
        this.setAttribute("cellspacing", "0");
        this.setAttribute("cellpadding", "2");
        for (int y = 0; y < p_contents.length; ++y) {
            this.pushContent(new TR());
            for (int x = 0; x < p_contents[0].length; ++x) {
                if (p_contents[y][x] != null) {
                    this.addContent(p_contents[y][x]);
                    continue;
                }
                this.addContent(new TD(new Image(Image.CLEAR, 1, 1)));
            }
            this.pop();
        }
    }

    public Table setBorder(int p_width) {
        this.setAttribute("border", "" + p_width);
        return this;
    }
}

