/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.jdomhtml;

import java.net.URLEncoder;
import java.util.StringTokenizer;

public class URL {
    private StringBuffer o_value;

    public URL() {
        this.o_value = new StringBuffer();
    }

    public URL(String p_value) {
        this.o_value = new StringBuffer(URL.URLEncodePath(p_value));
    }

    public URL(URL p_url) {
        this.o_value = new StringBuffer(p_url.o_value.toString());
    }

    public static URL fromURL(String p_url) {
        URL x_url = new URL();
        x_url.o_value = new StringBuffer(p_url);
        if (p_url.endsWith("/")) {
            x_url.o_value.setLength(x_url.o_value.length() - 1);
        }
        return x_url;
    }

    protected static String URLEncodePath(String p_path) {
        StringTokenizer x_tok = new StringTokenizer(p_path, "/\\", true);
        StringBuffer x_encodedPath = new StringBuffer();
        while (x_tok.hasMoreTokens()) {
            char x_t;
            String x_token = x_tok.nextToken();
            if (x_token.length() == 1 && ((x_t = x_token.charAt(0)) == '/' || x_t == '\\')) {
                x_encodedPath.append('/');
                continue;
            }
            x_encodedPath.append(URLEncoder.encode(x_token));
        }
        if (x_encodedPath.toString().indexOf(43) != -1) {
            StringBuffer x_path = x_encodedPath;
            x_encodedPath = new StringBuffer(x_path.length() + 3);
            for (int i = 0; i < x_path.length(); ++i) {
                char x_char = x_path.charAt(i);
                if (x_char == '+') {
                    x_encodedPath.append("%20");
                    continue;
                }
                x_encodedPath.append(x_char);
            }
        }
        return x_encodedPath.toString();
    }

    public void appendPath(String p_path) {
        int x_offset;
        if (!(p_path = URL.URLEncodePath(p_path)).startsWith("/")) {
            p_path = "/" + p_path;
        }
        if (p_path.endsWith("/")) {
            p_path = p_path.substring(0, p_path.length() - 1);
        }
        if ((x_offset = this.o_value.toString().indexOf(63)) != -1) {
            this.o_value.insert(x_offset, p_path);
        } else {
            this.o_value.append(p_path);
        }
    }

    public void addParameter(String p_name, int p_value) {
        this.addParameter(p_name, "" + p_value);
    }

    public void addParameter(String p_name, String p_value) {
        if (this.o_value.toString().indexOf(63) == -1) {
            this.o_value.append("?");
        } else {
            this.o_value.append("&");
        }
        this.o_value.append(p_name);
        this.o_value.append("=");
        this.o_value.append(URLEncoder.encode(p_value));
    }

    public String toString() {
        return this.o_value.toString();
    }

    public String getParameter(String p_name) {
        String p_value = this.o_value.toString();
        int x_index = -1;
        do {
            if ((x_index = p_value.indexOf(p_name + "=", x_index + 1)) != -1) continue;
            return null;
        } while (x_index != 0 && "?&".indexOf(this.o_value.charAt(x_index - 1)) == -1);
        int x_value = p_value.indexOf(38, x_index);
        if (x_value == -1) {
            return p_value.substring(x_index + p_name.length() + 1);
        }
        return p_value.substring(x_index + p_name.length() + 1, x_value);
    }

    public int length() {
        return this.o_value.length();
    }
}

