/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import java.io.IOException;
import java.util.Hashtable;
import net.hurstfrost.game.millebornes.persistance.AbstractSerialiserStream;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;
import net.hurstfrost.tools.Java14Enum;

public abstract class Card
implements Serialisable {
    protected CardType m_cardType;
    public static final String[] IDS = new String[]{"25", "50", "75", "100", "200", "STOP", "GO", "RESTRICT", "DERESTRICT", "NO_FUEL", "FUEL", "ACCIDENT", "GARAGE", "PUNCTURE", "TYRE", "EMERGENCY", "TANKER", "ACE_DRIVER", "PUNCTURE_PROOF"};
    private static final Hashtable g_idToIndexMap = new Hashtable();

    public Card() {
    }

    public Card(CardType cardType) {
        this.m_cardType = cardType;
    }

    public CardType getType() {
        return this.m_cardType;
    }

    public String getIdentifier() {
        return this.m_cardType.toString();
    }

    public void writeToStream(Serialiser serialiser) throws IOException {
        serialiser.write(this.m_cardType);
    }

    public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
        this.m_cardType = (CardType)serialiser.readObject();
    }

    public String toString() {
        return this.m_cardType.toString();
    }

    public static int indexOfId(String imageId) {
        Integer index = (Integer)g_idToIndexMap.get(imageId);
        if (index == null) {
            return -1;
        }
        return index;
    }

    static {
        AbstractSerialiserStream.registerSerialisable(Remedy.class, "r");
        AbstractSerialiserStream.registerSerialisable(Remedy.Type.class, "rt");
        AbstractSerialiserStream.registerSerialisable(Distance.class, "d");
        AbstractSerialiserStream.registerSerialisable(Distance.Type.class, "dt");
        AbstractSerialiserStream.registerSerialisable(Hazard.class, "h");
        AbstractSerialiserStream.registerSerialisable(Hazard.Type.class, "ht");
        AbstractSerialiserStream.registerSerialisable(Safety.class, "s");
        AbstractSerialiserStream.registerSerialisable(Safety.Type.class, "st");
        for (int i = 0; i < IDS.length; ++i) {
            g_idToIndexMap.put(IDS[i], new Integer(i));
        }
    }

    public static class Safety
    extends Card {
        public static final Safety PUNCTURE_PROOF_CARD = new Safety(Type.PUNCTURE_PROOF);
        public static final Safety EMERGENCY_CARD = new Safety(Type.EMERGENCY);
        public static final Safety ACE_DRIVER_CARD = new Safety(Type.ACE_DRIVER);
        public static final Safety TANKER_CARD = new Safety(Type.TANKER);

        public Safety() {
        }

        private Safety(Type type) {
            super(type);
        }

        public boolean protectsFrom(Hazard hazard) {
            return this.protectsFrom(hazard.getType());
        }

        public boolean protectsFrom(CardType hazard) {
            if (this.m_cardType.equals(Type.ACE_DRIVER)) {
                return hazard.equals(Hazard.Type.ACCIDENT);
            }
            if (this.m_cardType.equals(Type.EMERGENCY)) {
                return hazard.equals(Hazard.Type.STOP) || hazard.equals(Hazard.Type.RESTRICT);
            }
            if (this.m_cardType.equals(Type.PUNCTURE_PROOF)) {
                return hazard.equals(Hazard.Type.PUNCTURE);
            }
            if (this.m_cardType.equals(Type.TANKER)) {
                return hazard.equals(Hazard.Type.NO_FUEL);
            }
            throw new IllegalArgumentException();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Safety) {
                Safety otherSafety = (Safety)obj;
                return otherSafety.getType().equals(this.getType());
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode();
        }

        public static class Type
        extends CardType {
            public static final Type PUNCTURE_PROOF = new Type("PUNCTURE_PROOF");
            public static final Type EMERGENCY = new Type("EMERGENCY");
            public static final Type ACE_DRIVER = new Type("ACE_DRIVER");
            public static final Type TANKER = new Type("TANKER");
            public static final int SERIALISER_VERSION = 1;

            public Type() {
            }

            public Type(String identifier) {
                super(identifier);
            }
        }
    }

    public static class Remedy
    extends Card {
        public static final int NUM_FUEL = 6;
        public static final int NUM_TYRE = 6;
        public static final int NUM_GARAGE = 6;
        public static final int NUM_DERESTRICT = 6;
        public static final int NUM_GO = 14;

        public Remedy() {
        }

        public Remedy(Type type) {
            super(type);
        }

        public boolean isRemedyFor(Hazard hazard) {
            if (this.m_cardType.equals(Type.DERESTRICT)) {
                return hazard.getType().equals(Hazard.Type.RESTRICT);
            }
            if (this.m_cardType.equals(Type.GO)) {
                return hazard.getType().equals(Hazard.Type.STOP);
            }
            if (this.m_cardType.equals(Type.TYRE)) {
                return hazard.getType().equals(Hazard.Type.PUNCTURE);
            }
            if (this.m_cardType.equals(Type.FUEL)) {
                return hazard.getType().equals(Hazard.Type.NO_FUEL);
            }
            if (this.m_cardType.equals(Type.GARAGE)) {
                return hazard.getType().equals(Hazard.Type.ACCIDENT);
            }
            throw new IllegalArgumentException();
        }

        public Hazard.Type getRespectiveHazardType() {
            if (this.m_cardType.equals(Type.DERESTRICT)) {
                return Hazard.Type.RESTRICT;
            }
            if (this.m_cardType.equals(Type.GO)) {
                return Hazard.Type.STOP;
            }
            if (this.m_cardType.equals(Type.TYRE)) {
                return Hazard.Type.PUNCTURE;
            }
            if (this.m_cardType.equals(Type.FUEL)) {
                return Hazard.Type.NO_FUEL;
            }
            if (this.m_cardType.equals(Type.GARAGE)) {
                return Hazard.Type.ACCIDENT;
            }
            throw new IllegalArgumentException();
        }

        public static class Type
        extends CardType {
            public static final Type TYRE = new Type("TYRE");
            public static final Type FUEL = new Type("FUEL");
            public static final Type GARAGE = new Type("GARAGE");
            public static final Type GO = new Type("GO");
            public static final Type DERESTRICT = new Type("DERESTRICT");
            public static final int SERIALISER_VERSION = 1;

            public Type() {
            }

            public Type(String identifier) {
                super(identifier);
            }
        }
    }

    public static class Hazard
    extends Card {
        public static final int NUM_NO_FUEL = 3;
        public static final int NUM_PUNCTURE = 3;
        public static final int NUM_ACCIDENT = 3;
        public static final int NUM_RESTRICT = 4;
        public static final int NUM_STOP = 5;

        public Hazard() {
        }

        public Hazard(Type type) {
            super(type);
        }

        public static class Type
        extends CardType {
            public static final Type PUNCTURE = new Type("PUNCTURE");
            public static final Type NO_FUEL = new Type("NO_FUEL");
            public static final Type ACCIDENT = new Type("ACCIDENT");
            public static final Type STOP = new Type("STOP");
            public static final Type RESTRICT = new Type("RESTRICT");
            public static final int SERIALISER_VERSION = 1;

            public Type() {
            }

            public Type(String identifier) {
                super(identifier);
            }
        }
    }

    public static class Distance
    extends Card {
        public static final int NUM_25 = 10;
        public static final int NUM_50 = 10;
        public static final int NUM_75 = 10;
        public static final int NUM_100 = 12;
        public static final int NUM_200 = 4;

        public Distance() {
        }

        public Distance(int distance) {
            super(Type.getType(distance));
        }

        public int getDistance() {
            return ((Type)this.m_cardType).getDistance();
        }

        public static class Type
        extends CardType {
            public static final Type _25 = new Type(25);
            public static final Type _50 = new Type(50);
            public static final Type _75 = new Type(75);
            public static final Type _100 = new Type(100);
            public static final Type _200 = new Type(200);
            public static final int SERIALISER_VERSION = 1;
            private static Hashtable g_distanceToType;
            private int m_distance;

            public Type() {
            }

            private Type(int distance) {
                super("" + distance);
                if (g_distanceToType == null) {
                    g_distanceToType = new Hashtable();
                }
                g_distanceToType.put(new Integer(distance), this);
                this.m_distance = distance;
            }

            public static Type getType(int distance) {
                return (Type)g_distanceToType.get(new Integer(distance));
            }

            public int getDistance() {
                return this.m_distance;
            }

            public void writeToStream(Serialiser serialiser) throws IOException {
                super.writeToStream(serialiser);
                serialiser.write(this.m_distance);
            }

            public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
                super.readFromStream(serialiser, from, to);
                this.m_distance = serialiser.readInt();
            }
        }
    }

    public static abstract class CardType
    extends Java14Enum {
        public CardType() {
        }

        public CardType(String identifier) {
            super(identifier);
        }
    }
}

