/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hurstfrost.game.millebornes.Constants;
import net.hurstfrost.game.millebornes.model.Action;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.GameEventListener;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.Logger;
import net.hurstfrost.game.millebornes.model.NO_PLAY_REASON;
import net.hurstfrost.game.millebornes.model.NotificationReceiver;
import net.hurstfrost.game.millebornes.model.Pack;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.PlayerScore;
import net.hurstfrost.game.millebornes.model.Verb;
import net.hurstfrost.game.millebornes.persistance.AbstractSerialiserStream;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;
import net.hurstfrost.tools.EventListenerList;

public class Game
implements Serialisable,
Constants,
NotificationReceiver {
    public static final int GAME_END_SCORE = 5000;
    public static final String PLAYER_STAT_DISTANCE_TRAVELLED = "distanceTravelled";
    public static final String PLAYER_STAT_PREVIOUS_POINTS_SCORED = "previousPointsScored";
    public static final String GAME_STAT_HAND_START_TIME = "handStartTime";
    public static final String GAME_STAT_PLAYING_TIME = "gamePlayTime";
    public static final String PLAYER_STAT_COUP_FOURRE = "coupFourre";
    public static final String PLAYER_STAT_COACHED = "coached";
    private static Logger m_logger;
    private Pack m_pack = Pack.newPack();
    private Vector m_players = new Vector();
    private Hashtable m_playerScores = new Hashtable();
    private Hand m_hand;
    private transient EventListenerList m_listenerList;
    private int m_handStartPlayer = -1;
    private transient boolean m_disposed;
    private Hashtable m_options = new Hashtable();
    private transient Object m_persistedLocation;
    private transient boolean m_changedSinceSaved;
    private int m_handsPlayedThisGame = -1;
    private EventListenerList m_notificationReceiverList;

    public static final void log(Object object) {
        if (m_logger != null) {
            m_logger.log(object.toString());
        }
    }

    public static void setLogger(Logger logger) {
        m_logger = logger;
    }

    public static final void prepare() {
    }

    public Game() {
        Game.log("new Game()");
    }

    public int addPlayer(Player player) {
        if (this.m_players.size() >= 2) {
            throw new IllegalStateException("Too many players");
        }
        this.m_players.addElement(player);
        player.setGame(this);
        this.m_playerScores.put(player, new PlayerScore(this, player));
        return this.m_players.size();
    }

    public Player getCurrentPlayer() {
        int currentPlayerNumber = this.getHand().getCurrentPlayerNumber();
        if (currentPlayerNumber >= 0) {
            return this.getPlayer(currentPlayerNumber);
        }
        return null;
    }

    public int getPlayerNumber(Player player) {
        int indexOf = this.m_players.indexOf(player);
        if (indexOf < 0) {
            throw new RuntimeException("Player not found : '" + player + "'");
        }
        return indexOf;
    }

    public Player getOtherPlayer(Player player) {
        if (this.m_players.elementAt(0).equals(player)) {
            return (Player)this.m_players.elementAt(1);
        }
        return (Player)this.m_players.elementAt(0);
    }

    public boolean runOneTurn() {
        if (this.m_disposed) {
            return true;
        }
        if (this.getHand().isAwaitingExtensionResponse()) {
            if (this.getCurrentPlayer().getDistance() != 700 || this.getHand().getFinishLine() != 700) {
                throw new RuntimeException("Awaiting extension decision, but current Player not at end of short race.");
            }
            this.m_hand.checkExtend(this.getCurrentPlayer());
            if (this.getHand().isAwaitingExtensionResponse()) {
                return false;
            }
            this.checkHandComplete();
            this.getHand().nextPlayer();
            this.getCurrentPlayer().beforePlay();
        }
        if (this.isGameComplete()) {
            this.fireGameComplete();
        } else if (this.isHandComplete()) {
            this.fireHandComplete();
        }
        boolean runTurn = this.getCurrentPlayer().runTurn();
        if (this.isGameComplete()) {
            if (this.allPlayersReadyToProceed()) {
                this.nextGame(true);
            }
        } else if (this.isHandComplete() && this.allPlayersReadyToProceed()) {
            this.nextHand(true);
        }
        return runTurn;
    }

    private boolean allPlayersReadyToProceed() {
        Enumeration e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player player = (Player)e.nextElement();
            if (player.isReadyForNextHand()) continue;
            return false;
        }
        return true;
    }

    NO_PLAY_REASON requestPlayCard(Player player, Card card, boolean discard) {
        if (!player.equals(this.getCurrentPlayer())) {
            return NO_PLAY_REASON.WAIT_TURN;
        }
        int numCard = player.getHandIndexOf(card);
        boolean playAgain = false;
        if (numCard >= 0) {
            if (!player.isPlayable(card)) {
                throw new RuntimeException();
            }
            if (discard) {
                if (!player.isPickedUpThisTurn() && !this.getHand().getStock().isEmpty()) {
                    return NO_PLAY_REASON.PICKUP_FIRST;
                }
                player.discard(card);
            } else {
                NO_PLAY_REASON noPlayReason = this.m_hand.canPlayCard(player, card);
                if (noPlayReason != null) {
                    return noPlayReason;
                }
                playAgain = this.m_hand.playCard(player, numCard);
                Card removed = player.removeFromHand(numCard);
                if (removed != card) {
                    throw new RuntimeException();
                }
            }
            player.compactHand();
            this.m_hand.checkExtend(player);
            if (this.getHand().isAwaitingExtensionResponse()) {
                return null;
            }
            this.checkHandComplete();
            if (!playAgain || player.getHand().isEmpty()) {
                this.getHand().nextPlayer();
            }
        } else {
            return NO_PLAY_REASON.ILLEGAL;
        }
        this.getCurrentPlayer().beforePlay();
        return null;
    }

    void readyForNextHand(Player player) {
        if (!this.isHandComplete()) {
            throw new RuntimeException();
        }
        if (this.getCurrentPlayer().equals(player)) {
            this.getHand().nextPlayer();
            this.getCurrentPlayer().beforePlay();
        }
    }

    public void shuffle() {
        this.m_pack.shuffle();
    }

    public Hand getHand() {
        return this.m_hand;
    }

    void setHand(Hand hand) {
        this.m_hand = hand;
        hand.setGame(this);
        this.fireNewHand();
        this.setGameStat(GAME_STAT_HAND_START_TIME, System.currentTimeMillis() / 1000L);
    }

    void checkHandComplete() {
        Player player;
        if (this.m_hand.isComplete()) {
            return;
        }
        Game.log("Checking for end of Hand conditions");
        if (this.getHand().isAwaitingExtensionResponse()) {
            return;
        }
        Enumeration e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            player = (Player)e.nextElement();
            if (player.getDistance() > this.m_hand.getFinishLine()) {
                throw new RuntimeException("Player " + player + " has gone too far!");
            }
            if (player.getDistance() != this.m_hand.getFinishLine()) continue;
            this.handleNotification(player, "has reached the finish line");
            this.getHand().setWinner(player);
            return;
        }
        if (this.getHand().getStock().isEmpty()) {
            e = this.getPlayers().elements();
            while (e.hasMoreElements()) {
                player = (Player)e.nextElement();
                if (!this.getHand().canPlay(player)) continue;
                return;
            }
            Game.log("No players can go.");
            this.m_hand.setComplete(true);
        }
    }

    public boolean isHandComplete() {
        if (this.m_disposed) {
            return true;
        }
        return this.m_hand != null && this.m_hand.isComplete();
    }

    public boolean isGameComplete() {
        if (this.m_disposed) {
            return true;
        }
        if (!this.isHandComplete()) {
            return false;
        }
        Enumeration i = this.getPlayerScores().elements();
        while (i.hasMoreElements()) {
            PlayerScore playerScore = (PlayerScore)i.nextElement();
            if (playerScore.getGameTotal() < 5000) continue;
            return true;
        }
        return false;
    }

    public PlayerScore getScore(Player player) {
        return (PlayerScore)this.m_playerScores.get(player);
    }

    public static Game getNewGame() {
        Game game = new Game();
        return game;
    }

    public void dispose() {
        this.m_disposed = true;
        this.m_hand.dispose();
        this.m_players.removeAllElements();
        this.m_pack.removeAllElements();
        this.m_hand = null;
        this.m_players = null;
    }

    public Pack getPack() {
        return this.m_pack;
    }

    public Vector getPlayers() {
        return this.m_players;
    }

    public void setPlayers(Vector players) {
        this.m_players = players;
        this.m_playerScores.clear();
        Enumeration e = players.elements();
        while (e.hasMoreElements()) {
            Player player = (Player)e.nextElement();
            player.setGame(this);
            this.m_playerScores.put(player, new PlayerScore(this, player));
        }
    }

    public void nextHand(boolean deal) {
        if (this.m_hand != null && !this.m_hand.isComplete()) {
            throw new RuntimeException("The hand is not over");
        }
        if (this.m_hand != null && this.isGameComplete()) {
            throw new RuntimeException("The Game is over");
        }
        Enumeration<Object> e = this.getPlayerScores().elements();
        while (e.hasMoreElements()) {
            PlayerScore playerScore = (PlayerScore)e.nextElement();
            playerScore.endOfHand();
        }
        e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player player = (Player)e.nextElement();
            player.reset();
        }
        ++this.m_handsPlayedThisGame;
        this.shuffle();
        Hand newHand = Hand.getNewHand(this);
        newHand.initialiseStock();
        if (deal) {
            newHand.deal();
        }
        this.m_handStartPlayer = this.getPlayerNumberAfter(this.m_handStartPlayer);
        newHand.setPlayer(this.m_handStartPlayer);
        this.setHand(newHand);
        this.getCurrentPlayer().beforePlay();
    }

    public void nextGame(boolean deal) {
        PlayerScore playerScore;
        if (this.m_hand == null || !this.isGameComplete()) {
            throw new RuntimeException("The Game is not over");
        }
        Player winner = this.getWinningPlayer();
        this.handleNotification(winner, "wins the game");
        this.getScore(winner).incrementGamesWon();
        this.m_handsPlayedThisGame = 0;
        Enumeration<Object> e = this.getPlayerScores().elements();
        while (e.hasMoreElements()) {
            playerScore = (PlayerScore)e.nextElement();
            playerScore.endOfHand();
        }
        e = this.getPlayerScores().elements();
        while (e.hasMoreElements()) {
            playerScore = (PlayerScore)e.nextElement();
            playerScore.endOfGame();
        }
        e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player player = (Player)e.nextElement();
            player.reset();
        }
        this.shuffle();
        Hand newHand = Hand.getNewHand(this);
        newHand.initialiseStock();
        if (deal) {
            newHand.deal();
        }
        this.m_handStartPlayer = this.getPlayerNumberAfter(this.m_handStartPlayer);
        this.setHand(newHand);
        newHand.setPlayer(this.m_handStartPlayer);
        this.getCurrentPlayer().beforePlay();
    }

    public Player getWinningPlayer() {
        PlayerScore highestScore = null;
        Enumeration e = this.getPlayerScores().elements();
        while (e.hasMoreElements()) {
            PlayerScore playerScore = (PlayerScore)e.nextElement();
            if (highestScore == null) {
                highestScore = playerScore;
                continue;
            }
            if (playerScore.getGameTotal() > highestScore.getGameTotal()) {
                highestScore = playerScore;
                continue;
            }
            if (playerScore.getGameTotal() != highestScore.getGameTotal()) continue;
            if (this.getHand().getWinner() != null) {
                if (!this.getHand().getWinner().equals(playerScore.getPlayer())) continue;
                highestScore = playerScore;
                continue;
            }
            if (!this.getPlayer(this.m_handStartPlayer).equals(playerScore.getPlayer())) continue;
            highestScore = playerScore;
        }
        return highestScore.getPlayer();
    }

    int getPlayerNumberAfter(int playerNumber) {
        if (++playerNumber >= this.getPlayers().size()) {
            playerNumber = 0;
        }
        return playerNumber;
    }

    public void addGameEventListener(GameEventListener listener) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new EventListenerList();
        }
        this.m_listenerList.add(listener);
    }

    public void removeGameEventListener(GameEventListener listener) {
        this.m_listenerList.remove(listener);
    }

    public void addNotificationReceiver(NotificationReceiver listener) {
        if (this.m_notificationReceiverList == null) {
            this.m_notificationReceiverList = new EventListenerList();
        }
        this.m_notificationReceiverList.add(listener);
    }

    private void fireNewHand() {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onNewHand(this.getHand());
        }
    }

    void fireHandChanged() {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onHandChanged(this.getHand());
        }
    }

    void fireScoreChanged(Player player, PlayerScore playerScore) {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onScoreChanged(player, playerScore);
        }
    }

    private void fireHandComplete() {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onHandComplete();
        }
    }

    private void fireGameComplete() {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onGameComplete();
        }
    }

    void fireCardMoved(Card card, Player fromPlayer, Hand.PLAY_AREA fromPlayArea, Integer fromArg, Player toPlayer, Hand.PLAY_AREA toPlayArea, Integer toArg) {
        if (this.m_listenerList == null) {
            return;
        }
        this.setChangedSinceSaved(true);
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onCardMoved(card, fromPlayArea, fromPlayer, fromArg, toPlayArea, toPlayer, toArg);
        }
    }

    void firePlayerChanged(Player player) {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onPlayerChanged(player);
        }
    }

    void fireTurnChanged(Player player) {
        if (this.m_listenerList == null) {
            return;
        }
        Enumeration e = this.m_listenerList.getListeners().elements();
        while (e.hasMoreElements()) {
            GameEventListener listener = (GameEventListener)e.nextElement();
            listener.onTurnChanged(player);
        }
    }

    Hashtable getPlayerScores() {
        return this.m_playerScores;
    }

    public Player getPlayer(int playerNumber) {
        return (Player)this.m_players.elementAt(playerNumber);
    }

    public boolean isChangedSinceSaved() {
        return this.m_changedSinceSaved;
    }

    int getHandStartPlayer() {
        return this.m_handStartPlayer;
    }

    public void setOption(String option, String value) {
        if (value == null) {
            this.m_options.remove(option);
        } else {
            this.m_options.put(option, value);
        }
        this.setChangedSinceSaved(true);
    }

    public void setOption(String option, Serialisable value) {
        if (value == null) {
            this.m_options.remove(option);
        } else {
            this.m_options.put(option, value);
        }
        this.setChangedSinceSaved(true);
    }

    public Object getOption(String option) {
        if (this.m_options == null) {
            return null;
        }
        return this.m_options.get(option);
    }

    public String getStringOption(String option) {
        if (this.m_options == null) {
            return null;
        }
        try {
            return (String)this.m_options.get(option);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    void increasePlayerStat(Player player, String stat, int amount) {
        long value = this.getPlayerStat(player, stat);
        this.setPlayerStat(player, stat, value + (long)amount);
    }

    public long getPlayerStat(Player player, String stat) {
        long value = 0L;
        try {
            value = Long.parseLong(this.getStringOption(this.getPlayerNumber(player) + "." + stat));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return value;
    }

    public void setPlayerStat(Player player, String stat, long value) {
        this.setOption(this.getPlayerNumber(player) + "." + stat, "" + value);
    }

    void increaseGameStat(String stat, int amount) {
        long value = this.getGameStat(stat);
        this.setGameStat(stat, value + (long)amount);
    }

    public long getGameStat(String stat) {
        long value = 0L;
        try {
            value = Long.parseLong(this.getStringOption("GAME." + stat));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return value;
    }

    public void setGameStat(String stat, long value) {
        this.setOption("GAME." + stat, "" + value);
    }

    public Object getPersistedLocation() {
        return this.m_persistedLocation;
    }

    public void setPersistedLocation(Object saveLocation) {
        this.m_persistedLocation = saveLocation;
        this.m_changedSinceSaved = false;
    }

    public void setChangedSinceSaved(boolean changedSinceSaved) {
        this.m_changedSinceSaved = changedSinceSaved;
    }

    public int getHandsPlayedThisGame() {
        return this.m_handsPlayedThisGame;
    }

    public void setDisposed(boolean disposed) {
        this.m_disposed = disposed;
    }

    public void readFromStream(Serialiser serialiserStream, int from, int to) throws IOException {
        this.m_pack = (Pack)serialiserStream.readObject();
        this.m_hand = (Hand)serialiserStream.readObject();
        this.m_handsPlayedThisGame = serialiserStream.readInt();
        this.m_handStartPlayer = serialiserStream.readInt();
        this.m_options = (Hashtable)serialiserStream.readObject();
        this.m_players = (Vector)serialiserStream.readObject();
        this.m_playerScores = (Hashtable)serialiserStream.readObject();
        if (this.m_hand != null) {
            this.m_hand.activate();
        }
    }

    public void writeToStream(Serialiser serialiserStream) throws IOException {
        if (this.m_hand != null) {
            this.m_hand.passivate();
        }
        serialiserStream.write(this.m_pack);
        serialiserStream.write(this.m_hand);
        serialiserStream.write(this.m_handsPlayedThisGame);
        serialiserStream.write(this.m_handStartPlayer);
        serialiserStream.write(this.m_options);
        serialiserStream.write(this.m_players);
        serialiserStream.write(this.m_playerScores);
        if (this.m_hand != null) {
            this.m_hand.activate();
        }
    }

    public void handleNotification(Player player, String message) {
        Enumeration e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player p = (Player)e.nextElement();
            p.handleNotification(player, message);
        }
        if (this.m_notificationReceiverList != null) {
            e = this.m_notificationReceiverList.getListeners().elements();
            while (e.hasMoreElements()) {
                NotificationReceiver listener = (NotificationReceiver)e.nextElement();
                listener.handleNotification(player, message);
            }
        }
    }

    public void handleNotification(Player player, Action action, Verb verb, Card card) {
        Enumeration e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player p = (Player)e.nextElement();
            p.handleNotification(player, action, verb, card);
        }
        if (this.m_notificationReceiverList != null) {
            e = this.m_notificationReceiverList.getListeners().elements();
            while (e.hasMoreElements()) {
                NotificationReceiver listener = (NotificationReceiver)e.nextElement();
                listener.handleNotification(player, action, verb, card);
            }
        }
    }

    public boolean integrityCheck() {
        boolean integrity = true;
        Game.log("Check compaction");
        Enumeration e = this.getPlayers().elements();
        while (e.hasMoreElements()) {
            Player p = (Player)e.nextElement();
            if (p.getHand().indexOf(null) == -1) continue;
            Game.log("Hand has a gap.");
            integrity = false;
        }
        Game.log("Check pack card type");
        e = this.getPack().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Card) continue;
            Game.log("Pack contains a " + o.getClass());
            integrity = false;
        }
        Game.log("Integrity check result:" + integrity);
        return integrity;
    }

    public void setHandStartPlayer(int playerNumber) {
        this.m_handStartPlayer = playerNumber;
    }

    static {
        AbstractSerialiserStream.registerSerialisable(Game.class, "G");
        AbstractSerialiserStream.registerSerialisable(Hand.class, "H");
        AbstractSerialiserStream.registerSerialisable(Pack.class, "P");
        AbstractSerialiserStream.registerSerialisable(Player.class, "p");
        AbstractSerialiserStream.registerSerialisable(PlayerScore.class, "ps");
    }
}

