/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import net.hurstfrost.game.millebornes.model.AreaType;

public class LayoutArea {
    private static LayoutArea[] g_allAreas;
    private final AreaType m_areaType;
    private final Integer m_playerNumber;
    public static final LayoutArea SCORE_BOARD;
    public static final LayoutArea STOCK;
    public static final LayoutArea CARD_POOL;
    public static final LayoutArea DISCARD;
    public static final LayoutArea TRACK;

    public static LayoutArea[] getAllAreas() {
        if (g_allAreas == null) {
            g_allAreas = new LayoutArea[]{CARD_POOL, LayoutArea.HAND(0), LayoutArea.HAND(1), LayoutArea.BATTLE(0), LayoutArea.BATTLE(1), LayoutArea.LIMIT(0), LayoutArea.LIMIT(1), LayoutArea.DISTANCE(0), LayoutArea.DISTANCE(1), LayoutArea.SAFETY(0), LayoutArea.SAFETY(1)};
        }
        return g_allAreas;
    }

    private LayoutArea(AreaType areaType) {
        this.m_areaType = areaType;
        this.m_playerNumber = null;
    }

    private LayoutArea(AreaType areaType, int playerNumber) {
        this.m_areaType = areaType;
        this.m_playerNumber = new Integer(playerNumber);
    }

    public static LayoutArea HAND(int playerNumber) {
        return new LayoutArea(AreaType.HAND, playerNumber);
    }

    public static LayoutArea SAFETY(int playerNumber) {
        return new LayoutArea(AreaType.SAFETY, playerNumber);
    }

    public static LayoutArea BATTLE(int playerNumber) {
        return new LayoutArea(AreaType.BATTLE, playerNumber);
    }

    public static LayoutArea LIMIT(int playerNumber) {
        return new LayoutArea(AreaType.LIMIT, playerNumber);
    }

    public static LayoutArea DISTANCE(int playerNumber) {
        return new LayoutArea(AreaType.DISTANCE, playerNumber);
    }

    public AreaType getAreaType() {
        return this.m_areaType;
    }

    public Integer getPlayerNumber() {
        return this.m_playerNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutArea) {
            LayoutArea layoutArea = (LayoutArea)obj;
            return layoutArea.m_areaType.equals(this.m_areaType) && (this.m_playerNumber == null ? layoutArea.m_playerNumber == null : this.m_playerNumber.equals(layoutArea.m_playerNumber));
        }
        return false;
    }

    public int hashCode() {
        return this.m_areaType.hashCode() & (this.m_playerNumber == null ? 99 : this.m_playerNumber.hashCode());
    }

    public String toString() {
        return this.m_areaType + (this.m_playerNumber == null ? "" : this.m_playerNumber.toString());
    }

    static {
        SCORE_BOARD = new LayoutArea(AreaType.SCORE_BOARD);
        STOCK = new LayoutArea(AreaType.STOCK);
        CARD_POOL = new LayoutArea(AreaType.CARD_POOL);
        DISCARD = new LayoutArea(AreaType.DISCARD);
        TRACK = new LayoutArea(AreaType.TRACK);
    }
}

