/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.hurstfrost.game.millebornes.Constants;
import net.hurstfrost.game.millebornes.model.Action;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.NO_PLAY_REASON;
import net.hurstfrost.game.millebornes.model.NotificationReceiver;
import net.hurstfrost.game.millebornes.model.Play;
import net.hurstfrost.game.millebornes.model.Verb;
import net.hurstfrost.game.millebornes.model.YesNoLater;
import net.hurstfrost.game.millebornes.model.ai.PlayLogic;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;
import net.hurstfrost.tools.Tools;

public class Player
implements Constants,
Serialisable {
    private static final boolean COMPACT_HAND = true;
    private static final int MAX_PLAYLOGIC_RETRIES = 100;
    private static final String HMI_CLASS_NAME = "net.hurstfrost.game.millebornes.model.HMI";
    private static final String OLD_HMI_CLASS_NAME = "net.hurstfrost.game.millebornes.swing.HMI";
    private String m_name;
    private String m_id;
    private int m_distance;
    private Game m_game;
    private transient PlayLogic m_playLogic;
    private Vector m_battles = new Vector();
    private boolean m_pickedUpThisTurn;
    private Vector m_hand = new Vector();
    private Vector m_safeties = new Vector();
    private Vector m_coupFourres = new Vector();
    private Vector m_distances = new Vector();
    private Vector m_restrictions = new Vector();
    private int m_played;
    private int m_won;
    private boolean m_readyForNextHand;

    public Player() {
    }

    public Player(String name, String id, PlayLogic playLogic) {
        this.m_name = name;
        this.m_id = id;
        this.m_playLogic = playLogic;
        this.reset();
    }

    public Player(String name, PlayLogic playLogic) {
        this(name, null, playLogic);
    }

    public Player(String name) {
        this(name, null, null);
    }

    public Player(String name, String id) {
        this(name, id, null);
    }

    public String toString() {
        return this.m_name;
    }

    public void add(Card card) {
        this.m_hand.addElement(card);
    }

    public void pickup() {
        if (this.isPickedUpThisTurn()) {
            throw new RuntimeException();
        }
        if (this.m_hand.size() >= 8 && this.m_hand.indexOf(null) == -1) {
            throw new RuntimeException();
        }
        if (this.m_game.getHand().getStock().isEmpty()) {
            return;
        }
        while (this.m_hand.size() < 8 && !this.m_game.getHand().getStock().isEmpty()) {
            Card card = this.m_game.getHand().pickup();
            this.getGame().handleNotification(this, Action.PICKUP, Verb.PICKUP, card);
            this.m_hand.addElement(card);
            this.m_game.fireCardMoved(card, null, Hand.PLAY_AREA.STOCK, null, this, Hand.PLAY_AREA.HAND, new Integer(this.m_hand.size() - 1));
        }
        this.setPickedUpThisTurn(true);
    }

    public boolean isPlayable(Card card) {
        return this.m_hand.contains(card);
    }

    public void beforePlay() {
        this.setPickedUpThisTurn(false);
    }

    boolean runTurn() {
        NO_PLAY_REASON noPlayReason = null;
        Play play = null;
        int retryCount = 0;
        while (true) {
            try {
                if (this.m_playLogic != null) {
                    play = this.m_playLogic.takeTurn(this.m_game.getHand(), this);
                    if (play == null) {
                        Game.log("WARNING: PlayLogic responded with null.");
                    } else if (play.m_action == Action.DEFER && !this.m_playLogic.canRetry()) {
                        Game.log("Non-retryable PlayLogics should never return DEFER");
                        play = null;
                    }
                } else {
                    play = Play.DEFER;
                }
            }
            catch (Exception e) {
                Game.log("PlayLogic " + this.m_playLogic.getClass() + " threw " + e.getMessage());
                e.printStackTrace();
                play = null;
            }
            if (play != null && play.m_action == Action.DEFER) {
                return false;
            }
            noPlayReason = this.canExecuteTurn(play);
            if (noPlayReason == null) {
                this.executeTurn(play);
                break;
            }
            if (!this.m_playLogic.canRetry() || retryCount > 100) break;
            if (this.m_game.isGameComplete()) {
                return true;
            }
            ++retryCount;
        }
        if (noPlayReason != null) {
            Play defaultPlay = this.getDefaultPlay(play);
            Game.log("PlayLogic returned invalid move : " + noPlayReason + " doing " + defaultPlay + " instead");
            noPlayReason = this.canExecuteTurn(defaultPlay);
            if (noPlayReason == null) {
                this.executeTurn(defaultPlay);
            }
            if (noPlayReason != null) {
                throw new IllegalStateException("Default play should NEVER fail! : " + noPlayReason);
            }
        }
        return true;
    }

    private Play getDefaultPlay(Play play) {
        if (this.getGame().isGameComplete() || this.getGame().isHandComplete()) {
            return Play.NEXT_HAND;
        }
        if (this.isPickedUpThisTurn() || this.m_game.getHand().getStock().isEmpty()) {
            if (this.getHand().size() > 0) {
                return new Play((Card)this.getHand().elementAt(Tools.random(this.getHand().size())), Action.DISCARD);
            }
        } else {
            return Play.PICKUP;
        }
        throw new IllegalStateException("No reasonable default play available");
    }

    public NO_PLAY_REASON canExecuteTurn(Play play) {
        if (play == null) {
            return NO_PLAY_REASON.ILLEGAL;
        }
        if ((this.getGame().isHandComplete() || this.getGame().isGameComplete()) && play.m_action == Action.NEXT_HAND) {
            return null;
        }
        if (!this.equals(this.m_game.getCurrentPlayer())) {
            return NO_PLAY_REASON.WAIT_TURN;
        }
        if (play.m_action != Action.DEFER) {
            if (this.getGame().isHandComplete() || this.getGame().isGameComplete()) {
                if (play.m_action != Action.NEXT_HAND) {
                    return NO_PLAY_REASON.END_OF_HAND;
                }
            } else if (play.m_action == Action.NEXT_HAND) {
                return NO_PLAY_REASON.NOT_END_OF_HAND;
            }
            if (play.m_action == Action.PICKUP) {
                if (this.isPickedUpThisTurn()) {
                    return NO_PLAY_REASON.ALREADY_PICKED_UP;
                }
            } else if (play.m_action == Action.PLAY) {
                NO_PLAY_REASON canPlayCard = this.m_game.getHand().canPlayCard(this, play.m_card);
                if (canPlayCard != null) {
                    return canPlayCard;
                }
            } else if (play.m_action == Action.DISCARD && !this.isPickedUpThisTurn() && !this.m_game.getHand().getStock().isEmpty()) {
                return NO_PLAY_REASON.PICKUP_FIRST;
            }
        }
        return null;
    }

    public void executeTurn(Play play) {
        if (this.canExecuteTurn(play) != null) {
            throw new IllegalStateException("Illegal Play!");
        }
        if (play.m_action == Action.PICKUP) {
            this.pickup();
        } else if (play.m_action == Action.PLAY) {
            this.m_game.requestPlayCard(this, play.m_card, false);
        } else if (play.m_action == Action.DISCARD) {
            this.m_game.requestPlayCard(this, play.m_card, true);
        } else if (play.m_action == Action.NEXT_HAND) {
            this.setReadyForNextHand();
            this.m_game.readyForNextHand(this);
        }
    }

    private void setReadyForNextHand() {
        this.m_readyForNextHand = true;
        this.m_game.firePlayerChanged(this);
    }

    public boolean isReadyForNextHand() {
        return this.m_readyForNextHand;
    }

    void compactHand() {
        int to = this.m_hand.indexOf(null);
        if (to != -1) {
            for (int gap = to; gap < this.m_hand.size() - 1; ++gap) {
                Card pickup = (Card)this.m_hand.elementAt(gap + 1);
                this.m_hand.setElementAt(null, gap + 1);
                if (pickup == null) break;
                this.m_game.fireCardMoved(pickup, this, Hand.PLAY_AREA.HAND, new Integer(gap + 1), this, Hand.PLAY_AREA.HAND, new Integer(gap));
                if (this.m_hand.elementAt(gap) != null) {
                    throw new RuntimeException();
                }
                this.m_hand.setElementAt(pickup, gap);
            }
            if ((to = this.m_hand.indexOf(null)) != -1) {
                if (to != this.m_hand.size() - 1) {
                    throw new RuntimeException();
                }
                this.m_hand.removeElementAt(to);
            }
        }
        if (this.m_hand.size() > 7) {
            throw new RuntimeException();
        }
    }

    public void discard(Card card) {
        if (!this.isPlayable(card)) {
            throw new RuntimeException();
        }
        if (!this.isPickedUpThisTurn() && !this.m_game.getHand().getStock().isEmpty()) {
            throw new RuntimeException();
        }
        int numCard = this.getHandIndexOf(card);
        if (numCard < 0) {
            throw new RuntimeException();
        }
        this.m_game.getHand().discard(this, numCard);
        Card removed = this.removeFromHand(numCard);
        if (removed != card) {
            throw new RuntimeException();
        }
    }

    public void discardBattle() {
        if (this.m_battles.isEmpty()) {
            throw new RuntimeException();
        }
        this.m_game.getHand().discardBattle(this);
        this.m_battles.removeElementAt(this.m_battles.size() - 1);
    }

    public void discardRestriction() {
        if (this.m_restrictions.isEmpty()) {
            throw new RuntimeException();
        }
        this.m_game.getHand().discardRestriction(this);
        this.m_restrictions.removeElementAt(this.m_restrictions.size() - 1);
    }

    public int getDistance() {
        return this.m_distance;
    }

    public NO_PLAY_REASON canAdvance() {
        Card currentBattle = this.getCurrentBattle();
        if (currentBattle instanceof Card.Remedy) {
            Card.Remedy remedy = (Card.Remedy)currentBattle;
            if (remedy.getType().equals(Card.Remedy.Type.GO)) {
                return null;
            }
            if (this.m_safeties.contains(Card.Safety.EMERGENCY_CARD)) {
                return null;
            }
        } else if (currentBattle instanceof Card.Hazard) {
            if (this.m_safeties.contains(Card.Safety.EMERGENCY_CARD) && this.isProtectedFrom((Card.Hazard)currentBattle)) {
                return null;
            }
            return NO_PLAY_REASON.CANT_MOVE;
        }
        if (this.m_safeties.contains(Card.Safety.EMERGENCY_CARD)) {
            return null;
        }
        return NO_PLAY_REASON.CANT_MOVE;
    }

    public NO_PLAY_REASON canMove(int distance) {
        NO_PLAY_REASON reasonCantAdvance = this.canAdvance();
        if (reasonCantAdvance != null) {
            return reasonCantAdvance;
        }
        if (!this.m_safeties.contains(Card.Safety.EMERGENCY_CARD) && this.getCurrentRestriction() instanceof Card.Hazard && distance > 50) {
            return NO_PLAY_REASON.RESTRICTED;
        }
        if (this.m_distance + distance > this.m_game.getHand().getFinishLine()) {
            return NO_PLAY_REASON.TOO_FAR;
        }
        if (distance == 200) {
            int twoHundreds = 0;
            Enumeration e = this.m_distances.elements();
            while (e.hasMoreElements()) {
                Card.Distance distanceCard = (Card.Distance)e.nextElement();
                if (distanceCard.getDistance() != 200) continue;
                ++twoHundreds;
            }
            if (twoHundreds == 2) {
                return NO_PLAY_REASON.TOO_MANY_200;
            }
        }
        return null;
    }

    public void addDistance(Card.Distance distance) {
        this.m_distance += distance.getDistance();
        this.m_distances.addElement(distance);
        this.getGame().increasePlayerStat(this, "distanceTravelled", distance.getDistance());
        this.m_game.firePlayerChanged(this);
    }

    public void addBattle(Card card) {
        this.m_battles.addElement(card);
        this.m_game.firePlayerChanged(this);
    }

    public void addSafety(Card.Safety safety, boolean coupFourre) {
        this.m_safeties.addElement(safety);
        if (coupFourre) {
            this.m_coupFourres.addElement(safety);
            System.out.println("Coup fourr\u00e9 played with " + safety);
        }
        this.m_game.firePlayerChanged(this);
    }

    public void addRestrictions(Card card) {
        this.m_restrictions.addElement(card);
        this.m_game.firePlayerChanged(this);
    }

    public boolean isProtectedFrom(Card.Hazard hazard) {
        return this.isProtectedFrom(hazard.getType());
    }

    public boolean isProtectedFrom(Card.CardType hazardType) {
        if (hazardType.equals(Card.Hazard.Type.ACCIDENT)) {
            return this.m_safeties.contains(Card.Safety.ACE_DRIVER_CARD);
        }
        if (hazardType.equals(Card.Hazard.Type.RESTRICT) || hazardType.equals(Card.Hazard.Type.STOP)) {
            return this.m_safeties.contains(Card.Safety.EMERGENCY_CARD);
        }
        if (hazardType.equals(Card.Hazard.Type.NO_FUEL)) {
            return this.m_safeties.contains(Card.Safety.TANKER_CARD);
        }
        if (hazardType.equals(Card.Hazard.Type.PUNCTURE)) {
            return this.m_safeties.contains(Card.Safety.PUNCTURE_PROOF_CARD);
        }
        throw new IllegalStateException("Hazard " + hazardType + " is of unknown type");
    }

    public Vector getDistances() {
        return this.m_distances;
    }

    public Vector getHand() {
        return this.m_hand;
    }

    public String getName() {
        return this.m_name;
    }

    public final String getId() {
        return this.m_id;
    }

    public Vector getRestrictions() {
        return this.m_restrictions;
    }

    public Card getCurrentRestriction() {
        if (this.m_restrictions.isEmpty()) {
            return null;
        }
        return (Card)this.m_restrictions.elementAt(this.m_restrictions.size() - 1);
    }

    public Card getCurrentBattle() {
        if (this.m_battles.isEmpty()) {
            return null;
        }
        return (Card)this.m_battles.elementAt(this.m_battles.size() - 1);
    }

    public Vector getSafeties() {
        return this.m_safeties;
    }

    public Vector getBattles() {
        return this.m_battles;
    }

    public boolean isPickedUpThisTurn() {
        return this.m_pickedUpThisTurn;
    }

    private void setPickedUpThisTurn(boolean pickupThisTurn) {
        if (this.m_pickedUpThisTurn != pickupThisTurn) {
            this.m_pickedUpThisTurn = pickupThisTurn;
            this.m_game.firePlayerChanged(this);
        }
    }

    public Card removeFromHand(int numCard) {
        Card card = (Card)this.m_hand.elementAt(numCard);
        if (card == null) {
            throw new RuntimeException();
        }
        this.m_hand.setElementAt(null, numCard);
        return card;
    }

    public int getHandIndexOf(Card card) {
        return this.m_hand.indexOf(card);
    }

    Game getGame() {
        return this.m_game;
    }

    public PlayLogic getPlayLogic() {
        return this.m_playLogic;
    }

    void setGame(Game game) {
        this.m_game = game;
    }

    int getPlayed() {
        return this.m_played;
    }

    void setPlayed(int played) {
        this.m_played = played;
    }

    int getWon() {
        return this.m_won;
    }

    void setWon(int won) {
        this.m_won = won;
    }

    public void reset() {
        this.m_battles.removeAllElements();
        this.m_distance = 0;
        this.m_distances.removeAllElements();
        this.m_hand.removeAllElements();
        this.m_pickedUpThisTurn = false;
        this.m_restrictions.removeAllElements();
        this.m_safeties.removeAllElements();
        this.m_coupFourres.removeAllElements();
        this.m_readyForNextHand = false;
    }

    public Vector getCoupFourres() {
        return this.m_coupFourres;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setId(String id) {
        this.m_id = id;
    }

    public final void setPlayLogic(PlayLogic ai) {
        this.m_playLogic = ai;
    }

    public YesNoLater extendRace(Hand hand) {
        return this.m_playLogic.extendRace(hand, this);
    }

    public void writeToStream(Serialiser serialiser) throws IOException {
        serialiser.write(this.m_game);
        serialiser.write(this.m_hand);
        serialiser.write(this.m_name);
        serialiser.write(this.m_id);
        if (this.m_playLogic != null) {
            serialiser.write(this.m_playLogic.getClass().getName());
        } else {
            serialiser.write(null);
        }
        serialiser.write(this.m_distance);
        serialiser.write(this.m_pickedUpThisTurn);
        serialiser.write(this.m_readyForNextHand);
        serialiser.write(this.m_played);
        serialiser.write(this.m_won);
        serialiser.write(this.m_battles);
        serialiser.write(this.m_coupFourres);
        serialiser.write(this.m_distances);
        serialiser.write(this.m_restrictions);
        serialiser.write(this.m_safeties);
    }

    public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
        this.m_game = (Game)serialiser.readObject();
        this.m_hand = (Vector)serialiser.readObject();
        this.m_name = (String)serialiser.readObject();
        this.m_id = (String)serialiser.readObject();
        String className = (String)serialiser.readObject();
        if (OLD_HMI_CLASS_NAME.equals(className)) {
            className = HMI_CLASS_NAME;
        }
        if (className != null) {
            try {
                this.m_playLogic = (PlayLogic)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                Game.log("Can't instantiate a " + className);
                this.m_playLogic = null;
            }
        }
        this.m_distance = serialiser.readInt();
        this.m_pickedUpThisTurn = serialiser.readBoolean();
        this.m_readyForNextHand = serialiser.readBoolean();
        this.m_played = serialiser.readInt();
        this.m_won = serialiser.readInt();
        this.m_battles = (Vector)serialiser.readObject();
        this.m_coupFourres = (Vector)serialiser.readObject();
        this.m_distances = (Vector)serialiser.readObject();
        this.m_restrictions = (Vector)serialiser.readObject();
        this.m_safeties = (Vector)serialiser.readObject();
    }

    public void handleNotification(Player player, String message) {
        if (this.m_playLogic instanceof NotificationReceiver) {
            ((NotificationReceiver)((Object)this.m_playLogic)).handleNotification(player, message);
        }
    }

    public void handleNotification(Player player, Action action, Verb verb, Card card) {
        if (this.m_playLogic instanceof NotificationReceiver) {
            ((NotificationReceiver)((Object)this.m_playLogic)).handleNotification(player, action, verb, card);
        }
    }
}

