/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model.ai;

import java.util.Random;
import net.hurstfrost.game.millebornes.model.Action;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.Play;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.ai.PlayLogic;

public abstract class AiPlayer
implements PlayLogic {
    protected static Random g_random = new Random();

    public Play takeTurn(Hand hand, Player player) {
        int i = this.selectCard(hand, player);
        if (i < 0) {
            if (!player.isPickedUpThisTurn() && !hand.getStock().isEmpty()) {
                return Play.PICKUP;
            }
            i = this.selectDiscard(hand, player);
            return new Play((Card)player.getHand().elementAt(i), Action.DISCARD);
        }
        return new Play((Card)player.getHand().elementAt(i), Action.PLAY);
    }

    protected abstract int selectDiscard(Hand var1, Player var2);

    protected abstract int selectCard(Hand var1, Player var2);

    public boolean canRetry() {
        return false;
    }

    public boolean leaveGame() {
        return true;
    }
}

