/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model.ai;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hurstfrost.game.millebornes.model.Action;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.Play;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.YesNoLater;
import net.hurstfrost.game.millebornes.model.ai.CardVisitor;
import net.hurstfrost.game.millebornes.model.ai.PlayLogic;
import net.hurstfrost.tools.Tools;

public class Hard
implements PlayLogic {
    public YesNoLater extendRace(Hand hand, Player player) {
        return YesNoLater.NO;
    }

    public Play takeTurn(Hand hand, Player player) {
        Card discard;
        Vector allSafeties;
        Card remedy;
        Card coupFourre;
        Game game = hand.getGame();
        Player opponent = game.getOtherPlayer(player);
        if (!player.isPickedUpThisTurn() && (coupFourre = this.getCoupFourre(hand, player)) != null) {
            return new Play(coupFourre, Action.PLAY);
        }
        if (!player.isPickedUpThisTurn() && !game.getHand().getStock().isEmpty()) {
            return Play.PICKUP;
        }
        Card.Safety safety = this.getSafety(player, opponent, hand);
        if (safety != null) {
            return new Play(safety, Action.PLAY);
        }
        Card.Distance advance = this.getAdvance(player);
        if (advance != null && player.getDistance() + advance.getDistance() == game.getHand().getFinishLine()) {
            Vector safeties = this.getSafeties(player);
            if (!safeties.isEmpty()) {
                return new Play((Card)safeties.elementAt(0), Action.PLAY);
            }
            return new Play(advance, Action.PLAY);
        }
        Card attack = this.getAttack(player, opponent);
        if (!(attack == null || attack.getType().equals(Card.Hazard.Type.RESTRICT) && opponent.canAdvance() != null)) {
            return new Play(attack, Action.PLAY);
        }
        if ((player.getCurrentBattle() instanceof Card.Hazard || player.getCurrentRestriction() instanceof Card.Hazard || !this.canAdvance(player)) && (remedy = this.getRemedy(player)) != null) {
            return new Play(remedy, Action.PLAY);
        }
        if (this.canAdvance(player) && advance != null) {
            Vector safeties;
            if (player.getDistance() + advance.getDistance() == hand.getFinishLine() && !(safeties = this.getSafeties(player)).isEmpty()) {
                return new Play((Card)safeties.elementAt(0), Action.PLAY);
            }
            return new Play(advance, Action.PLAY);
        }
        if (attack != null) {
            return new Play(attack, Action.PLAY);
        }
        if (hand.getStock().isEmpty() && !(allSafeties = this.getSafeties(player)).isEmpty()) {
            return new Play((Card)allSafeties.elementAt(0), Action.PLAY);
        }
        return new Play(discard, (discard = this.getDiscard(game, player, opponent)) instanceof Card.Safety ? Action.PLAY : Action.DISCARD);
    }

    private Card.Safety getSafety(Player player, Player opponent, Hand hand) {
        Vector allSafeties = this.getSafeties(player);
        if (allSafeties.isEmpty()) {
            return null;
        }
        int opponentToGo = hand.getFinishLine() - opponent.getDistance();
        if ((opponentToGo == 200 || opponentToGo == 100 || opponentToGo == 75 || opponentToGo == 50 || opponentToGo == 25) && opponentToGo <= 200 && opponent.canAdvance() == null) {
            int opponentTwoHundreds = this.count200s(opponent);
            if (opponentToGo <= 100 || opponentTwoHundreds < 2) {
                boolean opponentRestricted = opponent.getCurrentRestriction() instanceof Card.Hazard;
                if (opponentToGo <= 50 || !opponentRestricted) {
                    return (Card.Safety)allSafeties.elementAt(0);
                }
            }
        }
        return null;
    }

    private Vector getSafeties(Player player) {
        final Vector allSafeties = new Vector();
        this.visitCards(player, new CardVisitor(){

            public Card found(Card card) {
                if (card instanceof Card.Safety) {
                    allSafeties.addElement(card);
                }
                return null;
            }
        });
        return allSafeties;
    }

    private Card getCoupFourre(Hand hand, Player player) {
        Card card;
        Card.Hazard hazard;
        if (hand.getLastTurnCard() instanceof Card.Hazard && ((hazard = (Card.Hazard)hand.getLastTurnCard()) == player.getCurrentBattle() || hazard == player.getCurrentRestriction()) && (card = this.visitCards(player, new CardVisitor(){

            public Card found(Card visitedCard) {
                Card.Safety safety;
                if (visitedCard instanceof Card.Safety && (safety = (Card.Safety)visitedCard).protectsFrom(hazard)) {
                    return safety;
                }
                return null;
            }
        })) != null) {
            return card;
        }
        return null;
    }

    private Card getDiscard(Game game, Player player, Player opponent) {
        Vector distances;
        int twoHundreds = this.count200s(player);
        Enumeration e = player.getHand().elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            if (card instanceof Card.Hazard) {
                Card.Hazard hazard = (Card.Hazard)card;
                if (!opponent.isProtectedFrom(hazard)) continue;
                return hazard;
            }
            if (card instanceof Card.Remedy) {
                final Card.Remedy remedy = (Card.Remedy)card;
                if (player.isProtectedFrom(remedy.getRespectiveHazardType())) {
                    return remedy;
                }
                Card safety = this.visitCards(player, new CardVisitor(){

                    public Card found(Card visitedCard) {
                        Card.Safety visitedSafety;
                        if (visitedCard instanceof Card.Safety && (visitedSafety = (Card.Safety)visitedCard).protectsFrom(remedy.getRespectiveHazardType())) {
                            return visitedCard;
                        }
                        return null;
                    }
                });
                if (safety == null) continue;
                return remedy;
            }
            if (!(card instanceof Card.Distance)) continue;
            Card.Distance distance = (Card.Distance)card;
            if (player.getDistance() + distance.getDistance() > game.getHand().getFinishLine()) {
                return distance;
            }
            if (distance.getDistance() != 200) continue;
            if (twoHundreds == 2) {
                return distance;
            }
            ++twoHundreds;
        }
        int distanceToGo = game.getHand().getFinishLine() - player.getDistance();
        Vector route = new Vector();
        int leftToGo = Hard.getRoute(this.sortDistances(player), distanceToGo, player.getCurrentRestriction() instanceof Card.Hazard, route);
        if (leftToGo == 0) {
            Vector distances2 = this.sortDistances(player);
            Enumeration e2 = route.elements();
            while (e2.hasMoreElements()) {
                Card.Distance distance = (Card.Distance)e2.nextElement();
                distances2.removeElement(distance);
            }
            if (!distances2.isEmpty()) {
                return (Card)distances2.elementAt(distances2.size() - 1);
            }
        }
        Hashtable typeToCount = this.sortHand(player);
        Hashtable<Integer, Vector<Card.CardType>> countToType = new Hashtable<Integer, Vector<Card.CardType>>();
        int highestCount = 0;
        Enumeration e3 = typeToCount.keys();
        while (e3.hasMoreElements()) {
            Card.CardType type = (Card.CardType)e3.nextElement();
            Integer count = (Integer)typeToCount.get(type);
            Vector<Card.CardType> types = (Vector<Card.CardType>)countToType.get(count);
            if (types == null) {
                types = new Vector<Card.CardType>();
                countToType.put(count, types);
            }
            types.addElement(type);
            if (highestCount >= count) continue;
            highestCount = count;
        }
        Card.CardType throwType = null;
        block3: for (int c = highestCount; c > 1; --c) {
            Vector types = (Vector)countToType.get(new Integer(c));
            if (types == null) continue;
            Enumeration e4 = types.elements();
            while (e4.hasMoreElements()) {
                Object nextElement = e4.nextElement();
                Card.CardType type = (Card.CardType)nextElement;
                if (!(type instanceof Card.Hazard.Type) && !(type instanceof Card.Remedy.Type) || type.equals(Card.Remedy.Type.GO) && c <= 2) continue;
                throwType = type;
                continue block3;
            }
        }
        if (throwType != null) {
            Enumeration e5 = player.getHand().elements();
            while (e5.hasMoreElements()) {
                Card card = (Card)e5.nextElement();
                if (!card.getType().equals(throwType)) continue;
                return card;
            }
        }
        if ((distances = this.sortDistances(player)).size() > 0) {
            return (Card)distances.elementAt(distances.size() - 1);
        }
        return (Card)player.getHand().elementAt(0);
    }

    static int getRoute(Vector distances, int distanceToGo, boolean limited, Vector route) {
        int lastDistanceTried = 0;
        for (int o = 0; o < distances.size(); ++o) {
            Card.Distance distance = (Card.Distance)distances.elementAt(o);
            if (distance.getDistance() == lastDistanceTried) {
                distances.removeElementAt(o);
                --o;
                continue;
            }
            if (limited && distance.getDistance() > 50) {
                distances.removeElementAt(o);
                --o;
                continue;
            }
            if (distance.getDistance() > distanceToGo) continue;
            distances.removeElementAt(o);
            route.addElement(distance);
            lastDistanceTried = distance.getDistance();
            if ((distanceToGo -= distance.getDistance()) == 0 || distances.size() == 0) {
                distances.removeAllElements();
                return distanceToGo;
            }
            Vector remaining = new Vector();
            Tools.addAll(remaining, distances);
            int leftToGo = Hard.getRoute(remaining, distanceToGo, limited, route);
            if (remaining.isEmpty()) {
                distances.removeAllElements();
                return leftToGo;
            }
            distances.insertElementAt(distance, o);
            route.removeElementAt(route.size() - 1);
            distanceToGo += distance.getDistance();
        }
        return distanceToGo;
    }

    private int count200s(Player player) {
        int twoHundreds = 0;
        Enumeration e = player.getDistances().elements();
        while (e.hasMoreElements()) {
            Card.Distance distanceCard = (Card.Distance)e.nextElement();
            if (distanceCard.getDistance() != 200) continue;
            ++twoHundreds;
        }
        return twoHundreds;
    }

    private Vector sortDistances(Player player) {
        final Vector distances = new Vector();
        this.visitCards(player, new CardVisitor(){

            public Card found(Card card) {
                if (card instanceof Card.Distance) {
                    Card.Distance newDistance = (Card.Distance)card;
                    boolean added = false;
                    for (int i = 0; i < distances.size(); ++i) {
                        Card.Distance distance = (Card.Distance)distances.elementAt(i);
                        if (distance.getDistance() >= newDistance.getDistance()) continue;
                        distances.insertElementAt(newDistance, i);
                        added = true;
                        break;
                    }
                    if (!added) {
                        distances.addElement(newDistance);
                    }
                }
                return null;
            }
        });
        return distances;
    }

    private Hashtable sortHand(Player player) {
        final Hashtable map = new Hashtable();
        this.visitCards(player, new CardVisitor(){

            public Card found(Card card) {
                Card.CardType key = card.getType();
                Integer value = (Integer)map.get(key);
                value = new Integer(value != null ? value + 1 : 1);
                map.put(key, value);
                return null;
            }
        });
        return map;
    }

    private Card visitCards(Player player, CardVisitor visitor) {
        Enumeration e = player.getHand().elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            Card found = visitor.found(card);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Card getRemedy(Player player) {
        Card.Remedy remedy;
        Card card;
        Enumeration e;
        Card battle = player.getCurrentBattle();
        if (battle instanceof Card.Hazard) {
            e = player.getHand().elements();
            while (e.hasMoreElements()) {
                card = (Card)e.nextElement();
                if (!(card instanceof Card.Remedy) || !(remedy = (Card.Remedy)card).isRemedyFor((Card.Hazard)battle)) continue;
                return remedy;
            }
        }
        if ((battle = player.getCurrentRestriction()) instanceof Card.Hazard) {
            e = player.getHand().elements();
            while (e.hasMoreElements()) {
                card = (Card)e.nextElement();
                if (!(card instanceof Card.Remedy) || !(remedy = (Card.Remedy)card).isRemedyFor((Card.Hazard)battle)) continue;
                return remedy;
            }
        }
        if (!(player.getCurrentBattle() instanceof Card.Hazard || player.getCurrentBattle() != null && player.getCurrentBattle().getType().equals(Card.Remedy.Type.GO))) {
            Card go = this.visitCards(player, new CardVisitor(){

                public Card found(Card card) {
                    Card.Remedy remedy;
                    if (card instanceof Card.Remedy && (remedy = (Card.Remedy)card).getType().equals(Card.Remedy.Type.GO)) {
                        return card;
                    }
                    return null;
                }
            });
            if (go != null) {
                return go;
            }
            return null;
        }
        return null;
    }

    private Card.Distance getAdvance(Player player) {
        Vector distances = this.sortDistances(player);
        Enumeration e = distances.elements();
        while (e.hasMoreElements()) {
            Card.Distance distance = (Card.Distance)e.nextElement();
            if (player.canMove(distance.getDistance()) != null) continue;
            return distance;
        }
        return null;
    }

    private Card getAttack(Player player, Player opponent) {
        Card.Hazard restrict = null;
        Enumeration e = player.getHand().elements();
        while (e.hasMoreElements()) {
            Card.Hazard hazard;
            Card card = (Card)e.nextElement();
            if (!(card instanceof Card.Hazard) || opponent.isProtectedFrom(hazard = (Card.Hazard)card)) continue;
            if (hazard.getType().equals(Card.Hazard.Type.RESTRICT)) {
                restrict = hazard;
                continue;
            }
            if (opponent.canAdvance() != null) continue;
            return card;
        }
        if (restrict != null && !(opponent.getCurrentRestriction() instanceof Card.Hazard)) {
            return restrict;
        }
        return null;
    }

    private boolean canAdvance(Player player) {
        return player.canAdvance() == null;
    }

    public boolean canRetry() {
        return false;
    }

    public String getName() {
        return "hard";
    }

    public boolean leaveGame() {
        return true;
    }
}

