/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.persistance;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.hurstfrost.game.millebornes.persistance.GamePersistenceManager;

public class MonitoredByteArrayInputStream
extends ByteArrayInputStream {
    private final GamePersistenceManager.Listener m_listener;
    private long m_lastNotified = -1L;

    public MonitoredByteArrayInputStream(GamePersistenceManager.Listener listener, byte[] bytes) {
        super(bytes);
        this.m_listener = listener;
    }

    public int read() {
        int read = super.read();
        this.sendProgressEvent();
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.sendProgressEvent();
        return read;
    }

    public int read(byte[] b, int off, int len) {
        int read = super.read(b, off, len);
        this.sendProgressEvent();
        return read;
    }

    private void sendProgressEvent() {
        long time = System.currentTimeMillis();
        if (time - this.m_lastNotified > 1000L || this.pos >= this.count) {
            this.m_listener.progress(this.pos * 100 / this.count);
            this.m_lastNotified = time;
        }
    }
}

