/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.hurstfrost.game.millebornes.Constants;
import net.hurstfrost.game.millebornes.model.Action;
import net.hurstfrost.game.millebornes.model.AreaType;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.model.LayoutArea;
import net.hurstfrost.game.millebornes.model.NO_PLAY_REASON;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.Verb;
import net.hurstfrost.game.millebornes.model.YesNoLater;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;
import net.hurstfrost.tools.Java14Enum;
import net.hurstfrost.tools.Tools;

public class Hand
implements Serialisable,
Constants {
    public static final int SHORT_RACE = 700;
    public static final int FULL_DISTANCE = 1000;
    private static final int DISCARD_ON_DEAL = 0;
    private static final boolean DISALLOW_NO_STOCK_COUP_FOURRE = false;
    private Game m_game;
    private Vector m_stock = new Vector();
    private Vector m_discard = new Vector();
    private int m_currentPlayerNumber = -1;
    private int m_turnNumber;
    private int m_finishLine = 700;
    private Player m_raceExtender;
    private Card m_lastTurnCard = null;
    private Player m_winner;
    private boolean m_complete;
    private boolean m_awaitingExtensionResponse;

    public Hand() {
    }

    private Hand(Game game) {
        this.m_game = game;
    }

    boolean canPlay(Player player) {
        if (!this.m_stock.isEmpty()) {
            return true;
        }
        Enumeration e = player.getHand().elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            if (this.canPlayCard(player, card) != null) continue;
            return true;
        }
        return false;
    }

    void initialiseStock() {
        if (this.m_game.getPlayers().size() != 2) {
            throw new IllegalStateException("Only two player game supported");
        }
        Tools.addAll(this.m_stock, this.m_game.getPack());
    }

    public void deal() {
        for (int n = 0; n < 7; ++n) {
            Enumeration i = this.m_game.getPlayers().elements();
            while (i.hasMoreElements()) {
                Player player = (Player)i.nextElement();
                Card card = this.getTopStockCard();
                player.add(card);
                this.m_stock.removeElementAt(0);
            }
        }
        for (int i = 0; i < 0; ++i) {
            this.m_stock.removeElementAt(0);
        }
        this.getGame().fireHandChanged();
    }

    int getCurrentPlayerNumber() {
        return this.m_currentPlayerNumber;
    }

    int nextPlayer() {
        Player newPlayer;
        while (true) {
            this.m_currentPlayerNumber = this.getGame().getPlayerNumberAfter(this.m_currentPlayerNumber);
            newPlayer = this.getGame().getPlayer(this.m_currentPlayerNumber);
            if (this.isComplete()) break;
            this.incrementTurn();
            if (!newPlayer.getHand().isEmpty()) break;
            this.getGame().handleNotification(newPlayer, "cannot play");
        }
        this.getGame().fireTurnChanged(newPlayer);
        return this.m_currentPlayerNumber;
    }

    void setPlayer(int playerNumber) {
        if (this.isComplete()) {
            throw new RuntimeException();
        }
        if (playerNumber < 0 || playerNumber >= this.getGame().getPlayers().size()) {
            throw new RuntimeException("Invalid player number " + playerNumber);
        }
        int oldPlayer = this.m_currentPlayerNumber;
        this.m_currentPlayerNumber = playerNumber;
        if (oldPlayer >= 0) {
            this.getGame().fireTurnChanged(this.getGame().getPlayer(this.m_currentPlayerNumber));
        }
    }

    public NO_PLAY_REASON canPlayCardToArea(Player player, Card card, LayoutArea toArea) {
        if (toArea.getAreaType() == AreaType.CARD_POOL) {
            return null;
        }
        if (card instanceof Card.Safety ? toArea.equals(LayoutArea.SAFETY(this.getGame().getPlayerNumber(player))) : (card instanceof Card.Remedy ? toArea.equals(LayoutArea.BATTLE(this.getGame().getPlayerNumber(player))) : (card instanceof Card.Hazard ? toArea.equals(LayoutArea.BATTLE(this.getGame().getPlayerNumber(this.getGame().getOtherPlayer(player)))) : card instanceof Card.Distance && toArea.equals(LayoutArea.DISTANCE(this.getGame().getPlayerNumber(player)))))) {
            return null;
        }
        return NO_PLAY_REASON.ILLEGAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NO_PLAY_REASON canPlayCard(Player player, Card card) {
        Card.Hazard hazard;
        Card.Safety safety;
        if (player.getHandIndexOf(card) == -1) {
            return NO_PLAY_REASON.DISALLOWED;
        }
        if (card instanceof Card.Safety && this.getLastTurnCard() instanceof Card.Hazard && (this.getLastTurnCard().equals(player.getCurrentBattle()) || this.getLastTurnCard().equals(player.getCurrentRestriction())) && (safety = (Card.Safety)card).protectsFrom(hazard = (Card.Hazard)this.getLastTurnCard())) {
            return null;
        }
        NO_PLAY_REASON playable = NO_PLAY_REASON.DISALLOWED;
        if (!player.isPickedUpThisTurn() && !this.getStock().isEmpty()) {
            return NO_PLAY_REASON.PICKUP_FIRST;
        }
        if (card instanceof Card.Distance) {
            Card.Distance distance = (Card.Distance)card;
            NO_PLAY_REASON reasonCantMove = player.canMove(distance.getDistance());
            if (reasonCantMove == null) return null;
            return reasonCantMove;
        }
        if (card instanceof Card.Remedy) {
            Card.Remedy remedy = (Card.Remedy)card;
            if (remedy.getType().equals(Card.Remedy.Type.GO)) {
                if (player.getCurrentBattle() == null) return null;
                if (player.getCurrentBattle() instanceof Card.Remedy) {
                    Card.Remedy rememdy = (Card.Remedy)player.getCurrentBattle();
                    if (!rememdy.getType().equals(Card.Remedy.Type.GO)) return null;
                    return NO_PLAY_REASON.ALREADY_GO;
                }
                if (!(player.getCurrentBattle() instanceof Card.Hazard)) throw new RuntimeException();
                Card.Hazard hazard2 = (Card.Hazard)player.getCurrentBattle();
                if (hazard2.getType().equals(Card.Hazard.Type.STOP)) return null;
                return NO_PLAY_REASON.MUST_REMEDY;
            }
            if (remedy.getType().equals(Card.Remedy.Type.GARAGE)) {
                if (!(player.getCurrentBattle() instanceof Card.Hazard)) {
                    return NO_PLAY_REASON.NOT_DAMAGED;
                }
                Card.Hazard hazard3 = (Card.Hazard)player.getCurrentBattle();
                if (hazard3.getType().equals(Card.Hazard.Type.ACCIDENT)) return null;
                return NO_PLAY_REASON.WRONG_REMEDY;
            }
            if (remedy.getType().equals(Card.Remedy.Type.FUEL)) {
                if (!(player.getCurrentBattle() instanceof Card.Hazard)) {
                    return NO_PLAY_REASON.NOT_OUT_OF_FUEL;
                }
                Card.Hazard hazard4 = (Card.Hazard)player.getCurrentBattle();
                if (hazard4.getType().equals(Card.Hazard.Type.NO_FUEL)) return null;
                return NO_PLAY_REASON.WRONG_REMEDY;
            }
            if (remedy.getType().equals(Card.Remedy.Type.DERESTRICT)) {
                if (player.getRestrictions().isEmpty()) {
                    return NO_PLAY_REASON.NOT_RESTRICTED;
                }
                if (player.getCurrentRestriction() instanceof Card.Hazard) return null;
                return NO_PLAY_REASON.NOT_RESTRICTED;
            }
            if (!remedy.getType().equals(Card.Remedy.Type.TYRE)) throw new RuntimeException();
            if (!(player.getCurrentBattle() instanceof Card.Hazard)) {
                return NO_PLAY_REASON.NOT_PUNCTURED;
            }
            Card.Hazard hazard5 = (Card.Hazard)player.getCurrentBattle();
            if (hazard5.getType().equals(Card.Hazard.Type.PUNCTURE)) return null;
            return NO_PLAY_REASON.WRONG_REMEDY;
        }
        if (card instanceof Card.Safety) {
            return null;
        }
        if (!(card instanceof Card.Hazard)) return playable;
        hazard = (Card.Hazard)card;
        Player attacked = this.getGame().getOtherPlayer(player);
        if (attacked.isProtectedFrom(hazard)) {
            return NO_PLAY_REASON.OPPONENT_PROTECTED;
        }
        if (hazard.getType().equals(Card.Hazard.Type.RESTRICT)) {
            if (attacked.getCurrentRestriction() instanceof Card.Hazard) return NO_PLAY_REASON.ALREADY_RESTRICTED;
            return null;
        }
        if (attacked.canAdvance() != null) return NO_PLAY_REASON.CANT_ATTACK_ATTACKED;
        return null;
    }

    boolean playCard(Player player, int handIndex) {
        Card card = (Card)player.getHand().elementAt(handIndex);
        if (card == null) {
            throw new RuntimeException("Card is null");
        }
        NO_PLAY_REASON reason = this.canPlayCard(player, card);
        if (reason != null) {
            throw new RuntimeException(player + " cannot play " + card + " because " + reason);
        }
        if (card instanceof Card.Distance) {
            Card.Distance distance = (Card.Distance)card;
            this.getGame().handleNotification(player, Action.PLAY, Verb.PLAY, card);
            this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), player, PLAY_AREA.DISTANCE, null);
            player.addDistance(distance);
        } else if (card instanceof Card.Remedy) {
            Card.Remedy remedy = (Card.Remedy)card;
            this.getGame().handleNotification(player, Action.PLAY, Verb.PLAY, card);
            if (remedy.getType().equals(Card.Remedy.Type.DERESTRICT)) {
                player.addRestrictions(remedy);
                this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), player, PLAY_AREA.LIMIT, null);
            } else {
                player.addBattle(remedy);
                this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), player, PLAY_AREA.BATTLE, null);
            }
        } else if (card instanceof Card.Safety) {
            Card.Safety safety = (Card.Safety)card;
            boolean coupFourre = !player.isPickedUpThisTurn();
            coupFourre = coupFourre && this.getLastTurnCard() instanceof Card.Hazard;
            coupFourre = coupFourre && (this.getLastTurnCard().equals(player.getCurrentBattle()) || this.getLastTurnCard().equals(player.getCurrentRestriction()));
            boolean bl = coupFourre = coupFourre && safety.protectsFrom((Card.Hazard)this.getLastTurnCard());
            if (!coupFourre) {
                Card.Hazard hazard;
                if (player.getCurrentBattle() instanceof Card.Hazard && safety.protectsFrom(hazard = (Card.Hazard)player.getCurrentBattle())) {
                    while (!player.getBattles().isEmpty()) {
                        Card currentBattle = player.getCurrentBattle();
                        if (currentBattle instanceof Card.Remedy) {
                            Card.Remedy remedy = (Card.Remedy)currentBattle;
                            if (card.getType().equals(Card.Safety.Type.EMERGENCY) || player.getSafeties().contains(Card.Safety.EMERGENCY_CARD) || !remedy.getType().equals(Card.Remedy.Type.GO)) break;
                        }
                        player.discardBattle();
                    }
                }
                if (player.getCurrentRestriction() instanceof Card.Hazard && safety.protectsFrom(hazard = (Card.Hazard)player.getCurrentRestriction())) {
                    Card currentRestriction;
                    while (!player.getRestrictions().isEmpty() && !((currentRestriction = player.getCurrentRestriction()) instanceof Card.Remedy)) {
                        player.discardRestriction();
                    }
                }
            } else {
                if (player.getCurrentBattle() instanceof Card.Hazard && safety.protectsFrom((Card.Hazard)player.getCurrentBattle())) {
                    player.discardBattle();
                }
                if (player.getCurrentRestriction() instanceof Card.Hazard && safety.protectsFrom((Card.Hazard)player.getCurrentRestriction())) {
                    player.discardRestriction();
                }
            }
            if (coupFourre) {
                this.getGame().handleNotification(player, Action.PLAY, Verb.COUPFOURRE, card);
                this.getGame().increasePlayerStat(player, "coupFourre", 1);
            } else {
                this.getGame().handleNotification(player, Action.PLAY, Verb.PLAY, card);
            }
            player.addSafety(safety, coupFourre);
            this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), player, PLAY_AREA.SAFETY, null);
        } else if (card instanceof Card.Hazard) {
            Card.Hazard hazard = (Card.Hazard)card;
            this.getGame().handleNotification(player, Action.PLAY, Verb.PLAY, card);
            Player attacked = this.getGame().getOtherPlayer(player);
            if (hazard.getType().equals(Card.Hazard.Type.RESTRICT)) {
                attacked.addRestrictions(hazard);
                this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), attacked, PLAY_AREA.LIMIT, null);
            } else {
                attacked.addBattle(hazard);
                this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), attacked, PLAY_AREA.BATTLE, null);
            }
        }
        this.setLastTurnCard(card);
        return card instanceof Card.Safety;
    }

    void checkExtend(Player player) {
        if (!player.equals(this.getGame().getCurrentPlayer())) {
            throw new RuntimeException();
        }
        if (player.getDistance() == 700 && this.m_finishLine == 700) {
            this.m_awaitingExtensionResponse = true;
            YesNoLater extendRace = player.extendRace(this);
            if (YesNoLater.YES.equals(extendRace)) {
                this.m_finishLine = 1000;
                this.setRaceExtender(player);
                this.getGame().handleNotification(player, "extends race to " + this.m_finishLine + " miles");
                this.getGame().fireHandChanged();
                this.m_awaitingExtensionResponse = false;
            } else if (YesNoLater.NO.equals(extendRace)) {
                this.getGame().handleNotification(player, "declines race extension");
                this.m_awaitingExtensionResponse = false;
            }
        }
    }

    public void discard(Player player, int handIndex) {
        Card card = (Card)player.getHand().elementAt(handIndex);
        if (card == null) {
            throw new RuntimeException();
        }
        this.getGame().handleNotification(player, Action.DISCARD, Verb.DISCARD, card);
        this.m_discard.addElement(card);
        this.getGame().fireCardMoved(card, player, PLAY_AREA.HAND, new Integer(handIndex), null, PLAY_AREA.DISCARD, null);
        this.setLastTurnCard(card);
    }

    public void discardBattle(Player player) {
        Card card = player.getCurrentBattle();
        this.m_discard.addElement(card);
        this.getGame().fireCardMoved(card, player, PLAY_AREA.BATTLE, null, null, PLAY_AREA.DISCARD, null);
    }

    public void discardRestriction(Player player) {
        Card card = player.getCurrentRestriction();
        this.m_discard.addElement(card);
        this.getGame().fireCardMoved(card, player, PLAY_AREA.LIMIT, null, null, PLAY_AREA.DISCARD, null);
    }

    public Card pickup() {
        Card pickup = this.getTopStockCard();
        this.m_stock.removeElementAt(0);
        this.setLastTurnCard(pickup);
        return pickup;
    }

    public Card getTopStockCard() {
        return this.m_stock.isEmpty() ? null : this.m_stock.elementAt(0);
    }

    public Vector getStock() {
        return this.m_stock;
    }

    public Vector getDiscard() {
        return this.m_discard;
    }

    public int getFinishLine() {
        return this.m_finishLine;
    }

    public void setFinishLine(int finishLine) {
        this.m_finishLine = finishLine;
    }

    public Card getLastTurnCard() {
        return this.m_lastTurnCard;
    }

    public void setLastTurnCard(Card card) {
        this.m_lastTurnCard = card;
    }

    public int getTurnNumber() {
        return this.m_turnNumber;
    }

    static Hand getNewHand(Game game) {
        Hand hand = new Hand(game);
        hand.activate();
        return hand;
    }

    public void exceptionThrown(Exception e) {
        e.printStackTrace();
    }

    public void dispose() {
        this.m_stock.removeAllElements();
        this.m_complete = true;
    }

    public Game getGame() {
        return this.m_game;
    }

    void incrementTurn() {
        ++this.m_turnNumber;
    }

    public void concede(Player player) {
        if (!this.m_game.getPlayers().contains(player)) {
            throw new RuntimeException();
        }
        this.setWinner(this.getGame().getOtherPlayer(player));
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    void setWinner(Player winner) {
        if (this.m_winner != null) {
            throw new RuntimeException();
        }
        this.m_winner = winner;
        this.setComplete(true);
        this.getGame().handleNotification(winner, "wins the hand");
        this.getGame().fireHandChanged();
    }

    void setGame(Game game) {
        this.m_game = game;
    }

    void activate() {
        this.passivate();
        if (!this.isComplete()) {
            this.m_game.setGameStat("handStartTime", System.currentTimeMillis() / 1000L);
        }
    }

    void passivate() {
        if (this.m_game.getGameStat("handStartTime") > 0L) {
            this.m_game.increaseGameStat("gamePlayTime", (int)(System.currentTimeMillis() / 1000L - this.m_game.getGameStat("handStartTime")));
            this.m_game.setGameStat("handStartTime", 0L);
        }
    }

    void setComplete(boolean complete) {
        if (!complete) {
            throw new RuntimeException();
        }
        if (this.m_complete) {
            throw new RuntimeException();
        }
        this.passivate();
        Game.log("The hand is complete");
        this.m_complete = true;
    }

    public Player getWinner() {
        return this.m_winner;
    }

    public Player getRaceExtender() {
        return this.m_raceExtender;
    }

    void setRaceExtender(Player raceExtender) {
        this.m_raceExtender = raceExtender;
    }

    public Card getFromStock(Card.CardType cardType) {
        Vector stock = this.getStock();
        Enumeration e = stock.elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            if (!card.getType().equals(cardType)) continue;
            stock.removeElement(card);
            return card;
        }
        throw new RuntimeException("Card " + cardType + " not found on remove.");
    }

    public void writeToStream(Serialiser serialiser) throws IOException {
        serialiser.write(this.m_complete);
        serialiser.write(this.m_currentPlayerNumber);
        serialiser.write(this.m_discard);
        serialiser.write(this.m_finishLine);
        serialiser.write(this.m_game);
        serialiser.write(this.m_lastTurnCard);
        serialiser.write(this.m_raceExtender);
        serialiser.write(this.m_stock);
        serialiser.write(this.m_turnNumber);
        serialiser.write(this.m_winner);
        serialiser.write(this.m_awaitingExtensionResponse);
    }

    public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
        this.m_complete = serialiser.readBoolean();
        this.m_currentPlayerNumber = serialiser.readInt();
        this.m_discard = (Vector)serialiser.readObject();
        this.m_finishLine = serialiser.readInt();
        this.m_game = (Game)serialiser.readObject();
        this.m_lastTurnCard = (Card)serialiser.readObject();
        this.m_raceExtender = (Player)serialiser.readObject();
        this.m_stock = (Vector)serialiser.readObject();
        this.m_turnNumber = serialiser.readInt();
        this.m_winner = (Player)serialiser.readObject();
        this.m_awaitingExtensionResponse = serialiser.readBoolean();
    }

    public boolean isAwaitingExtensionResponse() {
        return this.m_awaitingExtensionResponse;
    }

    public static class PLAY_AREA
    extends Java14Enum {
        public static final PLAY_AREA HAND = new PLAY_AREA("HAND");
        public static final PLAY_AREA BATTLE = new PLAY_AREA("BATTLE");
        public static final PLAY_AREA LIMIT = new PLAY_AREA("LIMIT");
        public static final PLAY_AREA DISTANCE = new PLAY_AREA("DISTANCE");
        public static final PLAY_AREA STOCK = new PLAY_AREA("STOCK");
        public static final PLAY_AREA DISCARD = new PLAY_AREA("DISCARD");
        public static final PLAY_AREA SAFETY = new PLAY_AREA("SAFETY");

        public PLAY_AREA(String identifer) {
            super(identifer);
        }
    }
}

