/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model;

import java.io.IOException;
import java.util.Enumeration;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.NullGameEventListener;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;

public class PlayerScore
implements Serialisable {
    public static final int SHUT_OUT = 200;
    public static final int EXTEND_RACE = 200;
    public static final int DELAYED_ACTION = 300;
    public static final int SAFE_TRIP = 200;
    public static final int TRIP_COMPLETE = 400;
    public static final int PER_COUP_FOURRE = 300;
    public static final int ALL_4_SAFETIES = 300;
    public static final int PER_SAFETY = 100;
    private Player m_player;
    private Game m_game;
    private int m_previousHandsTotal;
    private int m_gamesWon;
    private int m_lastAlertedGameTotal = -1;

    public PlayerScore() {
    }

    public PlayerScore(Game game, Player player) {
        this.setGame(game);
        this.m_player = player;
    }

    void endOfHand() {
        this.m_previousHandsTotal += this.getHandTotal();
    }

    void endOfGame() {
        this.getGame().increasePlayerStat(this.getPlayer(), "previousPointsScored", this.m_previousHandsTotal);
        this.m_previousHandsTotal = 0;
    }

    void incrementGamesWon() {
        ++this.m_gamesWon;
    }

    public int getGamesWon() {
        return this.m_gamesWon;
    }

    public int getGameTotal() {
        return this.m_previousHandsTotal + this.getHandTotal();
    }

    public void setGameTotal(int gameTotal) {
        this.m_previousHandsTotal = gameTotal;
    }

    public int getMileStones() {
        if (this.m_player == null) {
            return 0;
        }
        return this.m_player.getDistance();
    }

    public int getSafeties() {
        if (this.m_player == null) {
            return 0;
        }
        return this.m_player.getSafeties().size() * 100;
    }

    public int getAll4Safeties() {
        if (this.m_player == null) {
            return 0;
        }
        return this.m_player.getSafeties().size() == 4 ? 300 : 0;
    }

    public int getCoupFourre() {
        if (this.m_player == null) {
            return 0;
        }
        return this.m_player.getCoupFourres().size() * 300;
    }

    public int getDelayedAction() {
        if (this.m_game == null || this.m_player == null) {
            return 0;
        }
        if (!this.m_game.isHandComplete()) {
            return 0;
        }
        if (!this.m_player.equals(this.m_game.getHand().getWinner())) {
            return 0;
        }
        if (this.m_player.getDistance() != this.m_game.getHand().getFinishLine()) {
            return 0;
        }
        Hand hand = this.m_game.getHand();
        if (hand == null) {
            return 0;
        }
        return hand.getStock().isEmpty() ? 300 : 0;
    }

    public int getExtension() {
        if (this.m_game == null || this.m_player == null) {
            return 0;
        }
        Hand hand = this.m_game.getHand();
        if (hand == null) {
            return 0;
        }
        return this.m_player.equals(hand.getRaceExtender()) ? 200 : 0;
    }

    public int getTripComplete() {
        if (this.m_game == null || this.m_player == null) {
            return 0;
        }
        return this.m_game.isHandComplete() && this.m_player.getDistance() == this.m_game.getHand().getFinishLine() ? 400 : 0;
    }

    public int getSafeTrip() {
        if (this.m_game == null || this.m_player == null) {
            return 0;
        }
        if (!this.m_game.isHandComplete()) {
            return 0;
        }
        if (!this.m_player.equals(this.m_game.getHand().getWinner())) {
            return 0;
        }
        if (this.m_player.getDistance() != this.m_game.getHand().getFinishLine()) {
            return 0;
        }
        Enumeration i = this.m_player.getDistances().elements();
        while (i.hasMoreElements()) {
            Card.Distance distance;
            Card card = (Card)i.nextElement();
            if (!(card instanceof Card.Distance) || (distance = (Card.Distance)card).getDistance() != 200) continue;
            return 0;
        }
        return 200;
    }

    public int getShutOut() {
        if (this.m_game == null || this.m_player == null) {
            return 0;
        }
        Hand hand = this.m_game.getHand();
        if (hand == null) {
            return 0;
        }
        if (!this.m_player.equals(hand.getWinner())) {
            return 0;
        }
        if (this.m_player.getDistance() != hand.getFinishLine()) {
            return 0;
        }
        return this.m_game.getOtherPlayer(this.m_player).getDistance() == 0 ? 200 : 0;
    }

    public Game getGame() {
        return this.m_game;
    }

    public Player getPlayer() {
        return this.m_player;
    }

    public int getHandTotal() {
        return this.getMileStones() + this.getSafeties() + this.getAll4Safeties() + this.getCoupFourre() + this.getTripComplete() + this.getSafeTrip() + this.getDelayedAction() + this.getExtension() + this.getShutOut();
    }

    private void setGame(Game game) {
        this.m_game = game;
        this.m_game.addGameEventListener(new NullGameEventListener(){

            public void onCardMoved(Card card, Hand.PLAY_AREA fromPlayArea, Player fromPlayer, Integer fromArg, Hand.PLAY_AREA toPlayArea, Player toPlayer, Integer toArg) {
                PlayerScore.this.fireScoreChanged();
            }

            public void onHandChanged(Hand hand) {
                PlayerScore.this.fireScoreChanged();
            }

            public void onGameComplete() {
                PlayerScore.this.fireScoreChanged();
            }
        });
    }

    private void fireScoreChanged() {
        int gameTotal = this.getGameTotal();
        if (gameTotal != this.m_lastAlertedGameTotal) {
            this.getGame().fireScoreChanged(this.getPlayer(), this);
            this.m_lastAlertedGameTotal = gameTotal;
        }
    }

    int getPreviousHandsTotal() {
        return this.m_previousHandsTotal;
    }

    public void writeToStream(Serialiser serialiser) throws IOException {
        serialiser.write(this.m_gamesWon);
        serialiser.write(this.m_previousHandsTotal);
        serialiser.write(this.m_game);
        serialiser.write(this.m_player);
    }

    public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
        this.m_gamesWon = serialiser.readInt();
        this.m_previousHandsTotal = serialiser.readInt();
        this.setGame((Game)serialiser.readObject());
        this.m_player = (Player)serialiser.readObject();
    }

    public Object clone() {
        PlayerScore clone = new PlayerScore(this.m_game, this.m_player);
        clone.m_previousHandsTotal = this.m_previousHandsTotal;
        clone.m_gamesWon = this.m_gamesWon;
        clone.m_lastAlertedGameTotal = this.m_lastAlertedGameTotal;
        return clone;
    }
}

