/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.model.ai;

import java.util.Enumeration;
import java.util.Vector;
import net.hurstfrost.game.millebornes.Constants;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Hand;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.YesNoLater;
import net.hurstfrost.game.millebornes.model.ai.AiPlayer;
import net.hurstfrost.tools.Tools;

public class RandomOptimistic
extends AiPlayer
implements Constants {
    protected int selectCard(Hand hand, Player player) {
        Vector<Card> playableCards = new Vector<Card>();
        Vector handCards = player.getHand();
        Enumeration e = handCards.elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            if (hand.canPlayCard(player, card) != null) continue;
            playableCards.addElement(card);
        }
        if (playableCards.isEmpty()) {
            return -1;
        }
        Card.Safety playableSafety = null;
        while (!playableCards.isEmpty()) {
            int numCard = Tools.random(playableCards.size());
            Card playable = (Card)playableCards.elementAt(numCard);
            if (playable instanceof Card.Safety) {
                if (playableSafety == null) {
                    playableSafety = (Card.Safety)playable;
                }
                playableCards.removeElementAt(numCard);
                continue;
            }
            return handCards.indexOf(playable);
        }
        if (!hand.getGame().getCurrentPlayer().equals(player)) {
            throw new RuntimeException();
        }
        if (player.isPickedUpThisTurn()) {
            return -1;
        }
        return handCards.indexOf(playableSafety);
    }

    protected int selectDiscard(Hand hand, Player player) {
        Vector<Card> unplayableCards = new Vector<Card>();
        Vector handCards = player.getHand();
        if (handCards.isEmpty()) {
            System.err.println("Hand empty on RandomOptimistic.selectDiscard()");
            return -1;
        }
        Enumeration e = handCards.elements();
        while (e.hasMoreElements()) {
            Card card = (Card)e.nextElement();
            if (hand.canPlayCard(player, card) == null) continue;
            unplayableCards.addElement(card);
        }
        if (unplayableCards.isEmpty()) {
            return Tools.random(handCards.size());
        }
        int numCard = Tools.random(unplayableCards.size());
        return handCards.indexOf(unplayableCards.elementAt(numCard));
    }

    public YesNoLater extendRace(Hand game, Player player) {
        return Tools.random(10) > 7 ? YesNoLater.YES : YesNoLater.NO;
    }

    public String getName() {
        return "easy";
    }
}

