/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.persistance;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.persistance.GamePersistenceManager;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.SerialiserStream;

public abstract class AbstractGamePersistenceManager
implements GamePersistenceManager {
    public InputStream getInputStream() throws IOException {
        Object location = this.choosePersistenceLocation(true);
        if (location != null) {
            return this.getInputStream(location);
        }
        return null;
    }

    public Game activateGame() throws IOException {
        Game game = null;
        Object location = this.choosePersistenceLocation(true);
        if (location != null) {
            game = this.activateGame(location);
        }
        return game;
    }

    public Game activateGame(String locationName) throws IOException {
        return this.activateGame(this.getLocationFromName(locationName));
    }

    public Game activateGame(Object location) throws IOException {
        InputStream inputStream = this.getInputStream(location);
        if (inputStream == null) {
            return null;
        }
        Game game = this.readFromStream(inputStream);
        if (game != null) {
            game.setPersistedLocation(location);
            Game.log("Read " + game + " from " + this.getLocationName(location));
        }
        if (game == null || !game.integrityCheck()) {
            Game.log("WARNING: Activated game is null or fails integrity checks.");
        }
        return game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Game readFromStream(InputStream inputStream) throws IOException {
        SerialiserStream serialiser = null;
        Game.prepare();
        try {
            serialiser = new SerialiserStream(inputStream);
            Game game = (Game)serialiser.readObject();
            return game;
        }
        finally {
            try {
                if (serialiser != null) {
                    serialiser.close();
                }
            }
            catch (IOException e) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Object persistGame(Serialisable serializable) throws IOException {
        Object location = this.choosePersistenceLocation(false);
        if (location != null) {
            return this.persistGame(serializable, location);
        }
        return location;
    }

    public Object persistGame(Serialisable serializable, Object location) throws IOException {
        OutputStream outputStream = this.getOutputStream(location);
        if (serializable instanceof Game && (serializable == null || !((Game)serializable).integrityCheck())) {
            Game.log("WARNING: Game to persist is null or fails integrity checks.");
        }
        if (outputStream != null && this.writeToStream(serializable, outputStream)) {
            Game.log("Wrote game to " + this.getLocationName(location));
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeToStream(Serialisable serialisable, OutputStream outputStream) {
        SerialiserStream serialiser = null;
        try {
            serialiser = new SerialiserStream(outputStream);
            serialiser.write(serialisable);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (serialiser != null) {
                    serialiser.close();
                }
            }
            catch (IOException e) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    public String getLocationName(Object location) {
        if (location == null) {
            return null;
        }
        return location.toString();
    }

    public void deleteGame(Object location) {
        throw new RuntimeException("UnsupportedOperationExpection");
    }

    public boolean exists(Object location) {
        throw new RuntimeException("UnsupportedOperationExpection");
    }

    protected abstract OutputStream getOutputStream(Object var1) throws IOException;

    protected abstract InputStream getInputStream(Object var1) throws IOException;

    protected abstract Object choosePersistenceLocation(boolean var1);
}

