/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.persistance;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hurstfrost.game.millebornes.persistance.AbstractSerialiserStream;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.tools.NotSerialisableException;

public class SerialiserStream
extends AbstractSerialiserStream {
    private static final boolean ENABLE_PERSISTENCE_LOGGING = false;
    private static final String NUL = "%";
    private static final String REF = "#";
    private static final String CLS_REF = "&";
    private final InputStream m_inputStream;
    private final OutputStream m_outputStream;
    private final Hashtable m_refToObj = new Hashtable();
    private Hashtable m_rationalised = new Hashtable();
    private Vector m_refLookup = new Vector();

    public SerialiserStream(OutputStream stream) {
        this.m_outputStream = stream;
        this.m_inputStream = null;
    }

    public SerialiserStream(InputStream stream) {
        this.m_inputStream = stream;
        this.m_outputStream = null;
    }

    public void write(Object object) throws IOException {
        String ref;
        if (object == null) {
            this.writeString(NUL);
            return;
        }
        if (object instanceof String) {
            object = this.rationalise(object);
        }
        if ((ref = this.getRef(object)) != null) {
            this.writeString(REF);
            this.writeString(ref);
            return;
        }
        ref = this.setRef(object);
        this.writeClass(object.getClass());
        this.writeString(ref);
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Vector) {
            this.writeVector((Vector)object);
            return;
        }
        if (object instanceof Hashtable) {
            this.writeHashtable((Hashtable)object);
            return;
        }
        if (object instanceof Serialisable) {
            Serialisable serialisable = (Serialisable)object;
            serialisable.writeToStream(this);
            return;
        }
        throw new NotSerialisableException(object.getClass().getName());
    }

    private Object rationalise(Object object) {
        if (object == null) {
            return null;
        }
        Object rationalised = this.m_rationalised.get(object);
        if (rationalised == null) {
            this.m_rationalised.put(object, object);
            return object;
        }
        return rationalised;
    }

    public Object readObject() throws IOException {
        Object object;
        String className = this.readClass();
        if (className.equals(NUL)) {
            return null;
        }
        String ref = this.readString();
        if (className.equals(REF)) {
            Object object2 = this.m_refToObj.get(ref);
            if (object2 == null) {
                throw new NotSerialisableException("Unresolved reference " + ref);
            }
            return object2;
        }
        if (className.equals("java.util.Vector")) {
            Vector vector = new Vector();
            this.m_refToObj.put(ref, vector);
            object = this.readVector(vector);
        } else if (className.equals("java.util.Hashtable")) {
            Hashtable hashtable = new Hashtable();
            this.m_refToObj.put(ref, hashtable);
            object = this.readHashtable(hashtable);
        } else if (className.equals("java.lang.String")) {
            object = this.readString();
            this.m_refToObj.put(ref, object);
        } else {
            Serialisable serialisable;
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable e1) {
                throw new NotSerialisableException(className);
            }
            try {
                serialisable = (Serialisable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new NotSerialisableException(className + " : " + e);
            }
            this.m_refToObj.put(ref, serialisable);
            serialisable.readFromStream(this, 0, 0);
            object = serialisable;
        }
        return object;
    }

    public void close() throws IOException {
        if (this.m_inputStream != null) {
            this.m_inputStream.close();
        } else {
            this.m_outputStream.close();
        }
    }

    public void writeVector(Vector vector) throws IOException {
        this.write(vector.size());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            this.write(object);
        }
    }

    public Vector readVector(Vector vector) throws IOException {
        int i = this.readInt();
        for (int j = 0; j < i; ++j) {
            Object object = this.readObject();
            vector.addElement(object);
        }
        return vector;
    }

    private void writeHashtable(Hashtable hashtable) throws IOException {
        this.write(hashtable.size());
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.write(key);
            this.write(hashtable.get(key));
        }
    }

    private Object readHashtable(Hashtable hashtable) throws IOException {
        int size = this.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = this.readObject();
            hashtable.put(key, this.readObject());
        }
        return hashtable;
    }

    private void writeString(String string) throws IOException {
        byte[] bytes = string.getBytes("UTF-8");
        this.write(bytes.length);
        this.writeBytes(bytes);
    }

    private String readString() throws IOException {
        int length = this.readInt();
        byte[] stringBytes = new byte[length];
        this.m_inputStream.read(stringBytes);
        return new String(stringBytes, "UTF-8");
    }

    private void writeClass(Class clazz) throws IOException {
        String ref = this.getRef(clazz);
        if (ref != null) {
            this.writeString(CLS_REF);
            this.writeString(ref);
            return;
        }
        ref = this.setRef(clazz);
        this.writeString(this.getIdOfClass(clazz));
        this.writeString(ref);
    }

    private String getIdOfClass(Class clazz) {
        String id = (String)g_classToId.get(clazz);
        if (id != null) {
            return id;
        }
        throw new IllegalStateException("Class " + clazz.getName() + " has no ID");
    }

    private String getClassWithId(String id) {
        String className = (String)g_idToClassName.get(id);
        if (className != null) {
            return className;
        }
        throw new IllegalStateException("ID " + id + " not registered.");
    }

    private String readClass() throws IOException {
        String className = this.readString();
        if (className.equals(NUL) || className.equals(REF)) {
            return className;
        }
        String ref = this.readString();
        if (className.equals(CLS_REF)) {
            String clazz = (String)this.m_refToObj.get(ref);
            if (clazz == null) {
                throw new NotSerialisableException("Unresolved reference.");
            }
            return clazz;
        }
        className = this.getClassWithId(className);
        this.m_refToObj.put(ref, className);
        return className;
    }

    public void write(int i) throws IOException {
        byte[] bytes = new byte[4];
        int count = 0;
        for (int ii = i; count < 4 && ii != 0; ii >>= 8, ++count) {
            bytes[count] = (byte)(ii & 0xFF);
        }
        this.m_outputStream.write(count);
        this.m_outputStream.write(bytes, 0, count);
    }

    public int readInt() throws IOException {
        int bytes = this.readByte();
        int i = 0;
        int shift = 0;
        for (int count = 0; count < bytes; ++count) {
            i |= this.readByte() << shift;
            shift += 8;
        }
        return i;
    }

    public void write(boolean b) throws IOException {
        this.m_outputStream.write(b ? 1 : 0);
    }

    public boolean readBoolean() throws IOException {
        boolean b = this.readByte() != 0;
        return b;
    }

    private int readByte() throws IOException {
        int bite = this.m_inputStream.read();
        if (bite < 0) {
            throw new IOException();
        }
        return bite;
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.m_outputStream.write(bytes);
    }

    private String getRef(Object object) {
        int size = this.m_refLookup.size();
        for (int i = 0; i < size; ++i) {
            if (this.m_refLookup.get(i) != object) continue;
            return "" + i;
        }
        return null;
    }

    private String setRef(Object object) {
        this.m_refLookup.add(object);
        return "" + (this.m_refLookup.size() - 1);
    }

    static {
        SerialiserStream.registerSerialisable(Vector.class, "_V");
        SerialiserStream.registerSerialisable(String.class, "_S");
        SerialiserStream.registerSerialisable(Hashtable.class, "_H");
    }
}

