/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.game.millebornes.persistance;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import net.hurstfrost.game.millebornes.model.Card;
import net.hurstfrost.game.millebornes.model.Game;
import net.hurstfrost.game.millebornes.model.HMI;
import net.hurstfrost.game.millebornes.model.Player;
import net.hurstfrost.game.millebornes.model.ai.PlayLogic;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlGameReader
extends DefaultHandler {
    private static final String HAND_FINISH_LINE_ATTR = "finish-line";
    private static final String CARD_ELEMENT = "card";
    private static final String HAND_ELEMENT = "hand";
    private static final String RESTRICTION_ELEMENT = "restriction";
    private static final String BATTLE_ELEMENT = "battle";
    private static final String DISTANCE_ELEMENT = "distance";
    private static final String STOCK_ELEMENT = "stock";
    private static final String PLAYER_ELEMENT = "player";
    private static final String GAME_ELEMENT = "game";
    private static final String HAND_CARDS_ELEMENT = "hand-cards";
    private static final String STOCK_EMPTY_ATTR = "empty";
    private static final String CARD_TYPE_ATTR = "type";
    private static final String CARD_KIND_ATTR = "kind";
    private static final String PLAYER_SCORE_ATTR = "score";
    private static final String PLAYER_HAND_START_ATTR = "hand-start";
    private static final String PLAYER_LOGIC_ATTR = "logic";
    private static final String PLAYER_NUMBER_ATTR = "number";
    private Player m_currentPlayer;
    private boolean m_stockEmpty;
    private Vector m_stockCards;
    private final Game m_game = Game.getNewGame();
    private ParseMode m_parseMode;

    public static Game createGameFromXml(InputStream inputStream) throws SAXException, IOException {
        XmlGameReader documentHandler = new XmlGameReader();
        Vector<Player> players = new Vector<Player>();
        players.add(new Player("playerA", (PlayLogic)null));
        players.add(new Player("playerB", (PlayLogic)null));
        documentHandler.m_game.setPlayers(players);
        documentHandler.m_game.nextHand(false);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(documentHandler);
        reader.parse(new InputSource(inputStream));
        return documentHandler.m_game;
    }

    public void characters(char[] ch, int start, int length) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!qName.equals(GAME_ELEMENT)) {
            if (qName.equals(PLAYER_ELEMENT)) {
                int playerNumber;
                try {
                    playerNumber = Integer.parseInt(atts.getValue(PLAYER_NUMBER_ATTR));
                    this.m_currentPlayer = this.m_game.getPlayer(playerNumber);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("Can't get player " + atts.getValue(PLAYER_NUMBER_ATTR));
                }
                if (atts.getValue(PLAYER_LOGIC_ATTR) == null) {
                    this.m_currentPlayer.setPlayLogic(new HMI());
                } else {
                    try {
                        this.m_currentPlayer.setPlayLogic((PlayLogic)Class.forName(atts.getValue(PLAYER_LOGIC_ATTR)).newInstance());
                    }
                    catch (Exception e) {
                        throw new SAXException("Can't create PlayLogic " + atts.getValue(PLAYER_LOGIC_ATTR));
                    }
                }
                if (atts.getValue(PLAYER_SCORE_ATTR) != null) {
                    this.m_game.getScore(this.m_currentPlayer).setGameTotal(Integer.parseInt(atts.getValue(PLAYER_SCORE_ATTR)));
                }
                if (atts.getValue(PLAYER_HAND_START_ATTR) != null && Boolean.parseBoolean(atts.getValue(PLAYER_HAND_START_ATTR))) {
                    this.m_game.setHandStartPlayer(playerNumber);
                }
            } else if (qName.equals(HAND_CARDS_ELEMENT)) {
                this.m_parseMode = ParseMode.HAND_CARDS;
            } else if (qName.equals(CARD_ELEMENT)) {
                Card card = null;
                Card.CardType cardType = null;
                if (atts.getValue(CARD_TYPE_ATTR).equals("Safety")) {
                    cardType = (Card.CardType)Card.Safety.Type.valueOf(Card.Safety.Type.class, atts.getValue(CARD_KIND_ATTR));
                } else if (atts.getValue(CARD_TYPE_ATTR).equals("Hazard")) {
                    cardType = (Card.CardType)Card.Hazard.Type.valueOf(Card.Hazard.Type.class, atts.getValue(CARD_KIND_ATTR));
                } else if (atts.getValue(CARD_TYPE_ATTR).equals("Remedy")) {
                    cardType = (Card.CardType)Card.Remedy.Type.valueOf(Card.Remedy.Type.class, atts.getValue(CARD_KIND_ATTR));
                } else if (atts.getValue(CARD_TYPE_ATTR).equals("Distance")) {
                    cardType = (Card.CardType)Card.Distance.Type.valueOf(Card.Distance.Type.class, atts.getValue(CARD_KIND_ATTR));
                }
                if (cardType == null) {
                    throw new SAXException("Can't resolve card type " + atts.getValue(CARD_TYPE_ATTR) + ":" + atts.getValue(CARD_KIND_ATTR));
                }
                card = this.m_game.getHand().getFromStock(cardType);
                if (this.m_parseMode == ParseMode.HAND_CARDS) {
                    this.m_currentPlayer.add(card);
                } else if (this.m_parseMode == ParseMode.STOCK) {
                    this.m_stockCards.add(card);
                } else if (this.m_parseMode == ParseMode.DISTANCE) {
                    this.m_currentPlayer.addDistance((Card.Distance)card);
                } else if (this.m_parseMode == ParseMode.BATTLE) {
                    this.m_currentPlayer.addBattle(card);
                } else if (this.m_parseMode == ParseMode.RESTRICTION) {
                    this.m_currentPlayer.addRestrictions(card);
                }
            } else if (qName.equals(STOCK_ELEMENT)) {
                this.m_parseMode = ParseMode.STOCK;
                this.m_stockEmpty = Boolean.valueOf(atts.getValue(STOCK_EMPTY_ATTR));
                this.m_stockCards = new Vector();
            } else if (qName.equals(DISTANCE_ELEMENT)) {
                this.m_parseMode = ParseMode.DISTANCE;
            } else if (qName.equals(BATTLE_ELEMENT)) {
                this.m_parseMode = ParseMode.BATTLE;
            } else if (qName.equals(RESTRICTION_ELEMENT)) {
                this.m_parseMode = ParseMode.RESTRICTION;
            } else if (qName.equals(HAND_ELEMENT)) {
                this.m_parseMode = ParseMode.HAND;
                String finishLineValue = atts.getValue(HAND_FINISH_LINE_ATTR);
                if (finishLineValue != null) {
                    this.m_game.getHand().setFinishLine(Integer.parseInt(finishLineValue));
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals(PLAYER_ELEMENT)) {
            this.m_currentPlayer = null;
        } else if (qName.equals(HAND_CARDS_ELEMENT)) {
            this.m_parseMode = null;
        } else if (qName.equals(DISTANCE_ELEMENT)) {
            this.m_parseMode = null;
        } else if (qName.equals(BATTLE_ELEMENT)) {
            this.m_parseMode = null;
        } else if (qName.equals(RESTRICTION_ELEMENT)) {
            this.m_parseMode = null;
        } else if (qName.equals(STOCK_ELEMENT)) {
            this.m_parseMode = null;
            for (int i = this.m_stockCards.size() - 1; i >= 0; --i) {
                Card card = (Card)this.m_stockCards.elementAt(i);
                this.m_game.getHand().getStock().remove(card);
                this.m_game.getHand().getStock().add(0, card);
            }
            if (this.m_stockEmpty) {
                while (this.m_game.getHand().getStock().size() > this.m_stockCards.size()) {
                    this.m_game.getHand().getStock().remove(this.m_game.getHand().getStock().size() - 1);
                }
            }
        } else if (qName.equals(HAND_ELEMENT)) {
            this.m_parseMode = null;
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    private static class ParseMode {
        public static final ParseMode HAND_CARDS = new ParseMode();
        public static final ParseMode STOCK = new ParseMode();
        public static final ParseMode DISTANCE = new ParseMode();
        public static final ParseMode PLAYER = new ParseMode();
        public static final ParseMode BATTLE = new ParseMode();
        public static final ParseMode RESTRICTION = new ParseMode();
        public static final ParseMode HAND = new ParseMode();

        private ParseMode() {
        }
    }
}

