/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.tools;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hurstfrost.game.millebornes.persistance.Serialisable;
import net.hurstfrost.game.millebornes.persistance.Serialiser;

public abstract class Java14Enum
implements Serialisable {
    private String m_identifier;
    private static Hashtable g_enumClasses = new Hashtable();

    public Java14Enum() {
    }

    protected Java14Enum(String identifier) {
        this.m_identifier = identifier;
        this.addToValues(this);
    }

    private void addToValues(Java14Enum anEnum) {
        Hashtable<String, Java14Enum> enumMapping = (Hashtable<String, Java14Enum>)g_enumClasses.get(anEnum.getClass());
        if (enumMapping == null) {
            enumMapping = new Hashtable<String, Java14Enum>();
            g_enumClasses.put(anEnum.getClass(), enumMapping);
        }
        enumMapping.put(anEnum.getIdentifier(), anEnum);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Java14Enum) {
            Java14Enum otherEnum = (Java14Enum)obj;
            return this.m_identifier.equals(otherEnum.m_identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.m_identifier.hashCode();
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String toString() {
        return this.m_identifier;
    }

    public void readFromStream(Serialiser serialiser, int from, int to) throws IOException {
        this.m_identifier = (String)serialiser.readObject();
    }

    public void writeToStream(Serialiser serialiser) throws IOException {
        serialiser.write(this.m_identifier);
    }

    public static Vector values(Class enumType) {
        Hashtable enumMap = (Hashtable)g_enumClasses.get(enumType);
        if (enumMap == null) {
            throw new RuntimeException("No enum map found for class " + enumType.getName());
        }
        Enumeration e = enumMap.elements();
        Vector values = new Vector();
        while (e.hasMoreElements()) {
            values.addElement(e.nextElement());
        }
        return values;
    }

    public static Java14Enum valueOf(Class enumType, String identifier) {
        Hashtable enumMap = (Hashtable)g_enumClasses.get(enumType);
        if (enumMap == null) {
            throw new IllegalArgumentException();
        }
        return (Java14Enum)enumMap.get(identifier);
    }
}

